# ForceDelete

**Force delete files with reserved names (NUL, CON, PRN, AUX, etc.) that Windows Explorer can't handle.**

Windows reserves certain device names from the DOS era that cannot be used as filenames. However, these files can be created via WSL, network shares, AI coding tools, or buggy software. Explorer shows them but refuses to delete them.

ForceDelete fixes this with a right-click context menu option.

## Two Implementations

| Folder    | Type                       | Notes                                                                                                                                                                                          |
| --------- | -------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `CSharp/` | .NET Framework EXE         | Simple command-line tool doesn't solve the issue. **Limitation:** May trigger "These files can't be opened" security warning when invoked from context menu. Works reliably from command line. |
| `CPP/`    | Native Shell Extension DLL | **Recommended.** Implements `IShellExtInit` + `IContextMenu` to receive file paths directly, bypassing Explorer's security validation on target files.                                         |

## Quick Start (Recommended: C++ Shell Extension)

1. Open **x64 Native Tools Command Prompt for VS**
2. `cd CPP`
3. Run `BuildExt.cmd`
4. Right-click `ForceDeleteExt.inf` → **Install**
5. Right-click any file → **🙃 Force Delete**

## Why Two Versions?

The C# version was the original implementation. It works perfectly from the command line:

```
ForceDelete.exe "C:\path\to\nul"
```

However, when invoked from Explorer's context menu, Windows Security may block access to files in certain locations with "These files can't be opened" - the same security check that happens when you double-click a file.

The C++ shell extension solves this by implementing `IShellExtInit`, which receives file paths via `IDataObject` as raw strings - no security validation on the target file.

## How It Works

Both versions use the `\\?\` NT path prefix to bypass Windows' reserved name validation:

```
Standard path: C:\path\to\nul     → BLOCKED (reserved name)
NT path:       \\?\C:\path\to\nul → SUCCESS
```

The `\\?\` prefix tells Windows to pass the path directly to the NT kernel without parsing, where "nul" is just another filename.

## Files Deleted

- NUL, CON, PRN, AUX
- COM1-COM9, LPT1-LPT9
- Any file with trailing dots or spaces
- Any other "impossible" filename

## Build Requirements

- **C++ version:** Requires Visual Studio with C++ workload (for building the shell extension DLL)
- **C# version:** Can compile with just Windows — uses `csc.exe` from .NET Framework (no Visual Studio needed)

## Runtime Requirements

- **C++ version:** No runtime dependencies (native code)
- **C# version:** .NET Framework 4.x (built into Windows 10/11)

## License

MIT License - Copyright (c) 2026 HALRAD 

See LICENSE.txt for full terms.
