# ForceDelete (C# Version) - Specification

## Overview

A command-line utility and context menu tool to delete files with reserved names (NUL, CON, PRN, AUX, etc.) that Windows Explorer cannot handle.

## Limitations

**Important:** This version does NOT work with the shell handler (context menu). When invoked from Explorer's context menu, Windows Security blocks access to target files with "These files can't be opened" - the same security check that happens when double-clicking a file. This is because Explorer performs security validation on the target file when passing it as a `%1` argument to a shell command.

**For context menu operation, use the C++ shell extension in the `../CPP/` folder.**

This C# version works reliably from the command line only.

*(Of course, using a command-line EXE is no better than what you can already do with built-in commands: `del "\\.\C:\path\to\nul"`. If you have to open a console and type a path, you might as well use `del`.)*

## Technical Details

- **Language:** C# (.NET Framework 4.x)
- **Output:** Windows EXE (console subsystem with MessageBox for errors)
- **Dependencies:** None (uses .NET Framework built into Windows)
- **API:** P/Invoke to kernel32.dll (`DeleteFileW`, `GetFileAttributesW`, etc.)

## Command-Line Interface

```
ForceDelete.exe <path>
ForceDelete.exe "C:\path\to\nul"
```

**Exit Codes:**
- `0` - Success (or user cancelled)
- `1` - No argument provided
- `2` - File/directory not found
- `3` - Access denied
- `4` - Other error

## Features

- Confirmation prompt before deletion (Yes/No, defaults to No)
- Clears read-only attribute if set
- Handles both files and empty directories
- Supports UNC paths (`\\server\share\...`)
- Uses NT path prefix (`\\?\`) to bypass reserved name validation

## How It Works

1. Receives file path as command-line argument
2. Converts to NT path format (`\\?\C:\path\to\file`)
3. Shows confirmation dialog
4. Calls native Windows APIs via P/Invoke:
   - `GetFileAttributesW` - Check if file/directory exists
   - `SetFileAttributesW` - Clear read-only if needed
   - `DeleteFileW` or `RemoveDirectoryW` - Delete the item

## Files

| File | Description |
|------|-------------|
| `ForceDelete.cs` | C# source code |
| `ForceDelete.inf` | Windows Setup API installer |
| `ForceDelete.reg` | Manual registry entries (alternative) |
| `Build.cmd` | Build script (uses .NET Framework csc.exe) |

## Build

No Visual Studio required. Uses the .NET Framework compiler built into Windows:

```cmd
Build.cmd
```

Or manually:
```cmd
C:\Windows\Microsoft.NET\Framework64\v4.0.30319\csc.exe /nologo /target:winexe /out:ForceDelete.exe /reference:System.Windows.Forms.dll ForceDelete.cs
```

## Installation

1. Run `Build.cmd` to compile
2. Place `ForceDelete.exe` and `ForceDelete.inf` in the same folder
3. Right-click `ForceDelete.inf` → **Install**

Installs to `%ProgramFiles%\ForceDelete\` and adds "Force Delete" to the context menu.

## Uninstall

Use Add/Remove Programs → "ForceDelete"

## License

MIT License - Copyright (c) 2026 HALRAD
