@echo off
:: Build ForceDelete.exe using .NET Framework compiler (no Visual Studio required)
:: Copyright (c) 2025 HALRAD LLC - MIT License

setlocal

:: Find the .NET Framework directory
set FWDIR=C:\Windows\Microsoft.NET\Framework64\v4.0.30319
if not exist "%FWDIR%\csc.exe" set FWDIR=C:\Windows\Microsoft.NET\Framework\v4.0.30319

if not exist "%FWDIR%\csc.exe" (
    echo ERROR: Could not find csc.exe
    echo Make sure .NET Framework 4.x is installed
    pause
    exit /b 1
)

echo Compiling ForceDelete.exe...
echo.

"%FWDIR%\csc.exe" /nologo /target:winexe /out:ForceDelete.exe /reference:"%FWDIR%\System.Windows.Forms.dll" ForceDelete.cs

if %ERRORLEVEL% EQU 0 (
    echo SUCCESS: ForceDelete.exe created
    echo.
    echo Next steps:
    echo   1. Put ForceDelete.exe and ForceDelete.inf in the same folder
    echo   2. Right-click ForceDelete.inf and select "Install"
    echo.
) else (
    echo.
    echo FAILED: Compilation error
    echo.
)

pause
