# ForceDelete Shell Extension (C++ Version) - Specification

## Overview

A native Windows shell extension DLL that adds a "🙃 Force Delete" context menu item to delete files with reserved names (NUL, CON, PRN, AUX, etc.) that Windows Explorer cannot handle.

## Why This Version?

This is the **recommended** implementation. Unlike the C# EXE version, this shell extension:

- Receives file paths via `IDataObject` as raw strings
- Bypasses Explorer's security validation on target files
- Never triggers "These files can't be opened" warnings
- Integrates seamlessly with Explorer's context menu

## Technical Details

- **Language:** C++ (Win32)
- **Output:** Windows DLL (COM shell extension)
- **Dependencies:** None (Windows SDK only)
- **Interfaces:** `IShellExtInit`, `IContextMenu`
- **Registration:** `regsvr32` (self-registering COM server)

## COM Interface Implementation

### IShellExtInit::Initialize

Called by Explorer to pass selected files:
- Receives `IDataObject` containing file paths in `CF_HDROP` format
- Extracts file path using `DragQueryFileW`
- Stores path for later use by `InvokeCommand`

### IContextMenu::QueryContextMenu

Adds the menu item:
- Inserts "🙃 Force Delete" into the context menu
- Uses emoji prefix for visual identification

### IContextMenu::InvokeCommand

Performs the deletion:
1. Shows confirmation dialog (Yes/No, defaults to No)
2. Converts path to NT format (`\\?\C:\path\to\file`)
3. Clears read-only attribute if set
4. Calls `DeleteFileW` or `RemoveDirectoryW`
5. Shows error message on failure

## Registry Entries

The DLL self-registers under:

```
HKCR\CLSID\{B5E6D2F8-9A3C-4D1E-8F7B-2C4A6E8D0F1B}
HKCR\*\shellex\ContextMenuHandlers\ForceDelete
HKCR\Directory\shellex\ContextMenuHandlers\ForceDelete
HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Shell Extensions\Approved
```

## Files

| File | Description |
|------|-------------|
| `ForceDeleteExt.cpp` | C++ source code |
| `ForceDeleteExt.def` | DLL export definitions |
| `ForceDeleteExt.rc` | Version resource (author, version info) |
| `ForceDeleteExt.inf` | Windows Setup API installer |
| `BuildExt.cmd` | Build script (requires VS Developer Command Prompt) |
| `install.bat` | Quick install (self-elevates) |
| `uninstall.bat` | Quick uninstall (self-elevates) |

## Build

Requires Visual Studio with C++ workload:

1. Open **x64 Native Tools Command Prompt for VS**
2. Run `BuildExt.cmd`

Or manually:
```cmd
rc.exe /nologo /fo ForceDeleteExt.res ForceDeleteExt.rc
cl.exe /nologo /LD /EHsc /O2 /W3 /DUNICODE /D_UNICODE ForceDeleteExt.cpp ForceDeleteExt.res /link /DEF:ForceDeleteExt.def ole32.lib shell32.lib shlwapi.lib user32.lib advapi32.lib /OUT:ForceDeleteExt.dll
```

## Installation

### Method 1: INF Installer (Recommended)

1. Build the DLL
2. Right-click `ForceDeleteExt.inf` → **Install**

Copies DLL to `%ProgramFiles%\ForceDelete\`, registers it, and adds to Add/Remove Programs.

### Method 2: Manual

```cmd
regsvr32 ForceDeleteExt.dll
```

### Method 3: Quick Scripts

- `install.bat` - Self-elevates and runs regsvr32
- `uninstall.bat` - Self-elevates and runs regsvr32 /u

## Uninstall

- Add/Remove Programs → "ForceDelete"
- Or run `uninstall.bat`
- Or run `regsvr32 /u ForceDeleteExt.dll`

## Version Info

- **Product:** ForceDelete
- **Description:** ForceDelete - exists because Windows Explorer can't
- **Version:** 1.0.26.0101
- **Author:** HALRAD
- **Copyright:** Copyright (c) 2026 HALRAD

## Security Considerations

- Does not bypass NTFS ACLs (respects file permissions)
- Does not bypass file locks
- Shows confirmation before deletion
- Defaults to "No" for safety

## License

MIT License - Copyright (c) 2026 HALRAD
