Change Log
---------

# Versions

## 1.5.26.3 - 2026-January(04)

### Validated

- **MBRCPVAL Protocol Compliance** - Plugin passes protocol validation tests
  - v4.0 Protocol: 24/24 tests passed
  - v4.5 Protocol: All tests passed (with ARiA and Experimental features enabled)
  - Backward compatibility: v4.5 plugin passes all v4.0 tests
  - No code changes required
  - Note: MBRCPVAL validator is new and still being validated itself

## 1.5.26.1 - 2026-January(01)

### Added

- **MBRCPVAL - Protocol Validator Toolkit** - Comprehensive CLI toolkit for testing and validating MBRC protocol implementations
  
  - **Server Mode** - Validate running MBRC server/plugin against 52+ protocol tests
  
  - **Mock Mode** - Start a mock MBRC server for client development without MusicBee
  
  - **REPL Mode** - Interactive protocol exploration and testing
  
  - **Proxy Mode** - Intercept and log traffic between client and server for debugging
  
  - **Validate Mode** - Validate single JSON messages against protocol schemas
  
  - **Criticality Framework** - Tests categorized by importance:
    
    - `mandatory` (14 tests) - Must pass for basic protocol compliance
    - `recommended` (23 tests) - Should pass for good user experience
    - `optional` (15 tests) - May pass for full feature parity
  
  - **Certification Levels** - Bronze/Silver/Gold/Platinum based on test results
  
  - **Test Suites:**
    
    - `handshake.yaml` - Connection and protocol negotiation (8 tests)
    - `player-control.yaml` - Play, pause, volume, modes (14 tests)
    - `now-playing.yaml` - Track info, cover, lyrics, rating (10 tests)
    - `library.yaml` - Browse, search, pagination (10 tests)
    - `errors.yaml` - Error handling, robustness (10 tests)
  
  - **Reliability Infrastructure:**
    
    - Circuit breaker pattern for connection failures
    - Retry policy with exponential backoff
    - Connection health monitoring
    - Protocol fuzzing for edge case testing
    - Thread-safe operations throughout
  
  - **Documentation:**
    
    - Quick Start Guide with testing ecosystem overview
    - Criticality Framework document
    - Integration Plan for CI/CD pipelines
    - Protocol SDK mirror (MD format)
    - Backlog and Issues tracking
  
  - **Location:** `mbrcpval/` folder
  
  - **Requirements:** .NET 8.0+

## 1.5.25.1230 - 2025-December(30)

### Improved

- **Firewall Utility File Properties** - Added Win32 VERSIONINFO resources
  
  - File properties now display Company, Product, Description metadata
  - Visible in Windows Explorer Details tab and Task Manager
  - Publisher: "MusicBee Remote Control Plugin"
  - Description: "Firewall Configuration Update Agent"

- **Firewall Utility UAC Manifest** - Added embedded application manifest
  
  - Proper `requireAdministrator` manifest for UAC elevation
  - Windows 10/11 compatibility declared
  - Resources compiled from version.rc via Windows SDK rc.exe

## 1.5.25.1227 - 2025-December(27)

### Added

- **Plugin Instance ID** - Unique identifier for each plugin installation
  - New `plugininstanceid` protocol command returns stable GUID
  - Generated on first run and persisted to `settings.xml`
  - Enables clients to detect when connecting to a different MusicBee server
  - Useful for library cache invalidation when switching servers

### Improved

- **Settings Dialog Positioning** - InfoWindow now centers over MusicBee window
  
  - Previously appeared at default top-left screen position
  - Now calculates center position based on MusicBee window location and size
  - Handles minimized/maximized window states gracefully
  - Better UX when MusicBee is not maximized or on secondary monitors

- **Version Display with Build Epoch** - Version now includes hex Unix epoch suffix
  
  - Format: `1.5.25.1227+676e5a00` (SemVer build metadata convention)
  - Enables exact build identification from screenshots
  - Epoch is derived from build date for traceability

- **Settings Dialog Robustness** - Added defensive checks for edge cases
  
  - Port value clamped to valid NumericUpDown range
  - LastOctet value clamped to valid range
  - Null-safe version display with fallback
  - Exception handling in UpdateFilteringSelection

## 1.5.25.1226 - 2025-December(26)

### Added

- **Library Subscriptions** - Real-time library change notifications (Protocol v4.5)
  
  - `librarysubscribe` / `libraryunsubscribe` - Client opts in/out of change events
  - Plugin broadcasts `librarytagchanged`, `libraryratingchanged`, `libraryplaycounterchanged`, `libraryfiledeleted`
  - Enables client-side SQL cache to stay in sync without full library re-fetch

- **Remote Library Editing** - Edit ratings and love status from remote client
  
  - `librarysetrating` - Set track rating from client (0-5 scale, writes back to MusicBee)
  - `librarysetlove` - Set love/ban status from client (writes back to MusicBee)
  - Extended track model includes PlayCount, SkipCount, LastPlayed, Loved, Rating

- **Storage Path Command** - New `pluginstoragepath` command (v4.5, requires ARiA)
  
  - Returns `musicBeePath`, `pluginPath`, `itunesXml`, `itunesXmlExists`
  - Enables auto-discovery of iTunes XML export for cache validation
  - Security-gated: only available when ARiA is enabled

- **Remote Library Editing**
  
  - `librarysetrating` - Set track rating from client (0-5 scale)
  - `librarysetlove` - Set love/ban status from client

- **Playlist Queue Command**
  
  - `playlistqueue` - Append playlist to now playing (vs replace)
  - Fixes "Add to Queue" vs "Play" behavior for playlists

- **DateAdded Field**
  
  - `dateadded` field in `browsetracks` response (v4.5)

## 1.5.25.1225 - 2025-December(25)

### Added

- **Extended Library Metadata (v4.5)** - Track data now includes engagement fields
  
  - `playcount` - Number of times track has been played
  - `skipcount` - Number of times track was skipped
  - `lastplayed` - Date/time track was last played
  - `loved` - Love status: "L" = Loved, "B" = Banned, "" = Neither
  - Enables client-side caching of play statistics and favorites
  - Supports advanced queries: "most played", "recently played", "favorites"

- **Library Change Events (Foundation)** - Plugin now subscribes to MusicBee TagEvents
  
  - `TagsChanged` - Fires when track metadata is modified
  - `RatingChanged` - Fires when track rating changes
  - `PlayCountersChanged` - Fires when play/skip counts update
  - `FileDeleted` - Fires when file is removed from library
  - Foundation for Library Subscriptions feature (broadcast to clients in v4.5)

- **ARiA Help Button** - Quick access to ARiA documentation from settings dialog.

### Fixed

- **JSON Serialization Compatibility** - Fixed Android/iOS client discovery and metadata display issues
  
  - **ServiceDiscovery.cs**: Changed from ServiceStack.Text to Newtonsoft.Json
    
    - `JsonObject.Parse` → `JObject.Parse`
    - `JsonSerializer.SerializeToString` → `JsonConvert.SerializeObject`
    - Mobile clients expect Newtonsoft.Json's lowercase JSON keys
  
  - **SocketMessage.cs**: Changed ToJsonString() to use Newtonsoft.Json
    
    - All protocol messages now serialize with correct format
    - Fixes "unknown track/title" metadata display on mobile clients
  
  - **ProtocolHandler.cs**: Changed from ServiceStack.Text to Newtonsoft.Json
    
    - Consistent JSON parsing across all protocol handling
  
  - **SocketTester.cs**: Changed from ServiceStack.Text to Newtonsoft.Json
    
    - Internal testing now uses same JSON library as production

- **ServiceDiscovery Cleanup** - Added `DropMulticastGroup()` call before closing UDP clients
  
  - Properly leaves multicast group on shutdown
  - Prevents potential network resource leaks

### Improved

- **Build System** - Streamlined build and packaging workflow
  - Automatic version.res regeneration from version.rc during builds
  - Source packaging scripts exclude development files (*claude*.cmd, msbuild.log)
  - Consolidated package scripts in project root

## 1.5.25.1224 - 2025-December(24)

### Added

- **Initiator Actions Command Implementations** - Full implementation of all documented RIA commands
  
  - `mouseClick(x, y [, button])` - Remote mouse clicks at screen coordinates with left/right/middle button support
  - `volume(action)` - Windows system volume control (up, down, mute, toggle, numeric steps)
  - `restart(target)` - Restart MusicBee (`musicbee`, `mb`, `app`) or host system (`system`, `host`, `shutdown`)
  - `run(program [, args])` - Launch programs on host with optional arguments

- **Experimental Features Setting** - New plugin setting to enable experimental features
  
  - Checkbox in plugin configuration: "Enable Experimental Features"
  - Visualizer commands (`playervisualizer`, `playervisualizerlist`) now require this setting
  - Returns `{"error": "Not Enabled"}` when experimental features are disabled
  - Setting saved to `experimental_features` in settings.xml

### Changed

- **Protocol Version Negotiation** - Plugin now negotiates protocol version based on client request
  - Client requests v4 → server responds v4.0 (no extended metadata, backward compatible)
  - Client requests v4.5+ → server responds v4.5 (extended track metadata included)
  - ARiA setting is independent from protocol version (controls keyboard automation only)
  - Backward compatible with legacy Android/iOS clients

### Fixed

- **Thread Safety: Authenticator.AddClientOnConnect Race Condition** (Authenticator.cs)
  
  - Changed from ContainsKey+Remove+TryAdd pattern to atomic `AddOrUpdate`
  - Prevents race condition when multiple clients connect simultaneously

- **Thread Safety: SocketServer TOCTOU in Send Operations** (SocketServer.cs)
  
  - All three Send methods (`Send(message, clientId)`, `Send(message)`, `Broadcast`) now wrapped in try-catch
  - Catches `SocketException` and `ObjectDisposedException` when socket closes between check and send
  - Gracefully removes dead sockets instead of crashing

- **Empty Catch Blocks** - Added proper logging to silently swallowed exceptions
  
  - SocketServer.cs: Socket cleanup on buffer overflow now logs errors
  - ServiceDiscovery.cs: LocalEndPoint access failure now logs errors

- **ARiA DoS Protection** (AriaCommandExecutor.cs)
  
  - `delay()` command now capped at 30 seconds maximum to prevent abuse
  - Process.Start() calls now properly wrapped in `using` statements to dispose resources

# 

## 1.5.25.1222 - 2025-December(22)

### Added

- **MusicBee API 3.1 Interface Upgrade** - Updated from API revision 48 to 53
  
  - Adds support for MusicBee v3.1+ features
  - New APIs: `Player_PlayPreviousAlbum`, `Player_PlayNextAlbum` (album navigation)
  - New APIs: Podcast subscription support (`Podcasts_*` methods)
  - New APIs: `NowPlaying_GetSoundGraphEx`, `Sync_FileDeleteStart/End`
  - New notification types: `PlayingTracksChanged`, `PlaylistCreated/Updated/Deleted`
  - Additional metadata types: `SortTitle`, `SortAlbum`, `Work`, `MovementName`, etc.
  - **Backward Compatible:** Works with MusicBee v2.0 through v3.1+

- **Album Navigation Commands** - Skip entire albums in the now playing list
  
  - `playerpreviousalbum` - Skip to previous album
  - `playernextalbum` - Skip to next album
  - Requires MusicBee 3.1+ (gracefully degrades on older versions)

- **Podcast Support** - Browse and play podcast subscriptions
  
  - `podcastsubscriptions` - Get list of podcast subscriptions
  - `podcastepisodes` - Get episodes for a subscription
  - `podcastplay` - Play a podcast episode
  - Requires MusicBee 3.1+ (gracefully degrades on older versions)

- **Enhanced Debug Logging** - Comprehensive logging for resource cleanup
  
  - Socket server disposal logging with connection state
  - Service discovery cleanup logging
  - Socket tester cleanup logging
  - Safe property access patterns (won't crash if socket is in bad state)
  - Log rotation: 1MB/7 files for debug mode, 4MB/3 files for normal

- **Extended Track Metadata** - Library browse tracks now includes additional metadata fields (requires client to request v4.5 protocol)
  
  - Added `Year` field - track release year from MetaDataType.Year
  - Added `Rating` field - star rating from MetaDataType.Rating
  - Added `Bitrate` field - audio bitrate from FilePropertyType.Bitrate
  - Added `Format` field - audio format from FilePropertyType.Format
  - **Note:** These fields are only sent when the client requests protocol v4.5+
  - Enables clients to display and search by these fields in library views

### Fixed

- **Resource Cleanup in Plugin.Close()** - Proper cleanup of timers, event handlers, and InfoWindow on plugin shutdown
  
  - Timer event handlers now properly unsubscribed before disposal
  - InfoWindow disposed when plugin closes
  - Prevents memory leaks on plugin reload/disable

- **GDI Resource Leaks in Image Processing** (Utilities.cs)
  
  - EncoderParameters now properly disposed using `using` statements
  - Graphics objects use `using` for guaranteed disposal
  - Image objects in StoreResizedStream now properly disposed

- **Socket Resource Leaks**
  
  - SocketServer.Dispose() now closes all worker sockets, not just main socket
  - ServiceDiscovery.Start() cleans up UDP clients on setup failure
  - SocketTester cleans up sockets in all error paths

- **DoS Protection** - Added 2MB limit on partial message buffer to prevent memory exhaustion from malformed clients (sized to accommodate large album artwork)

- **Visualizer Control** - Fixed `MB_ShowVisualiser` to run on UI thread
  
  - Visualizer window operations now properly marshaled to MusicBee's UI thread
  - May resolve issues with visualizer not appearing when triggered remotely

## 1.5.10.26 - 2025-October(10)

⚠️ **IMPORTANT:** This version adds new JSON fields to `browseartists` and `browsegenres` responses. This may be incompatible with original Android/iOS clients. See `BREAKING_CHANGES_1.5.10.26.md` for details and testing requirements.

### Fixed

- **Album and Artist Count Bugs** - Fixed critical metadata bugs causing album and artist counts to display as zero
  
  - **Plugin ArtistData Missing AlbumCount** (ArtistData.cs:5-14)
    
    - Added `AlbumCount` property to `ArtistData` class
    - Previously only sent track counts, now includes album counts per artist
    - Enables clients to display "5 albums, 50 tracks" instead of just track count
  
  - **Plugin GenreData Missing ArtistCount** (GenreData.cs:8-19)
    
    - Added `ArtistCount` property to `GenreData` class
    - Previously only sent track counts, now includes unique artist counts per genre
    - Enables proper genre statistics display in clients
  
  - **Plugin LibraryBrowseArtists Incomplete Metadata** (Plugin.cs:1566-1598)
    
    - Now queries album counts for each artist from MusicBee library
    - Builds dictionary mapping artists to their album counts
    - Updates `ArtistData` objects with correct album counts before sending to clients
    - Handles errors gracefully with try-catch and logging
  
  - **Plugin LibraryBrowseGenres Incomplete Metadata** (Plugin.cs:1533-1566)
    
    - Now queries unique artist counts for each genre from MusicBee library
    - Uses `HashSet<string>` to count distinct artists per genre
    - Updates `GenreData` objects with correct artist counts before sending to clients
    - Handles errors gracefully with try-catch and logging

- **Critical Memory and Resource Leaks** - Fixed 5 critical bugs that could cause resource exhaustion and crash MusicBee
  
  - **Timer Resource Leak in SocketServer** (SocketServer.cs:72-77, 106-108)
    
    - Timer created in `Start()` was never disposed or stopped
    - Multiple restarts would create multiple timers that kept firing every 15 seconds
    - Now properly disposed in both `Stop()` and `Dispose()` methods
    - Set to null after cleanup to prevent re-use
  
  - **UDP Socket Leak in ServiceDiscovery** (ServiceDiscovery.cs:18, 39, 43-66)
    
    - UDP clients created in loop were never stored or disposed
    - No `Stop()` method existed to clean up discovery sockets
    - Added `_udpClients` list to track all UDP client instances
    - Created new `Stop()` method to properly dispose all UDP clients
    - Integrated cleanup into `StopSocketServer` command (StopSocketServer.cs:11)
  
  - **Socket Handle Leak in SocketTester** (SocketTester.cs:51-53, 64, 79-88)
    
    - Socket `Shutdown()` called but never `Close()` or `Dispose()`
    - Socket handles leaked on every connection test
    - Added proper socket disposal in both success and error paths
    - Sockets now properly cleaned up even on connection failures
  
  - **Null Reference Crash in SocketServer.Dispose()** (SocketServer.cs:74-76)
    
    - `Dispose()` called `_mainSocket.Dispose()` without null check
    - Would crash with NullReferenceException if called before `Start()`
    - Added null-conditional operators (`?.`) to prevent crashes
    - Method is now safe to call regardless of initialization state
  
  - **Silent Exception Swallowing in Controller** (Controller.cs:5, 12, 38, 45-47, 57-59)
    
    - All exceptions caught and silently ignored with no logging
    - Bugs were hidden and commands failed silently making debugging impossible
    - Added NLog logger to Controller class
    - Now logs errors when events/types are missing
    - Logs warnings when commands aren't registered
    - Logs full exception details for all command execution failures

### Improved

- **Crash Protection** - Added global exception handlers to all MusicBee plugin entry points (Plugin.cs:126-212, 347-366, 371-390, 429-506)
  
  - `Initialise()` - Catches all initialization exceptions, logs to file if logging unavailable, returns minimal PluginInfo to allow MusicBee to continue
  - `Close()` - Catches all shutdown exceptions to prevent crashes during MusicBee exit
  - `ReceiveNotification()` - Catches all player event exceptions to prevent crashes during playback
  - `Uninstall()` - Catches all uninstall exceptions to prevent crashes during plugin removal
  - **Impact:** Plugin exceptions can NO LONGER crash MusicBee - errors are logged and swallowed
  - **Safety:** Multi-level exception handling (logger → file → silent) ensures MusicBee always protected

- **Error Visibility** - All command execution failures are now logged with full stack traces

- **Resource Cleanup** - All network resources (sockets, timers, UDP clients) now properly disposed

- **Stability** - Plugin will no longer leak resources or crash MusicBee due to resource exhaustion

- **Debuggability** - Silent failures eliminated; all errors visible in logs

## 1.5.1 - 2025-September(09)

### Added

- **ARiA (Arbitrary Remote Initiated Actions)** - New security-controlled system for remote keyboard automation
  
  - Disabled by default for security - must be explicitly enabled in plugin settings
  - New checkbox in plugin settings: "Enable ARiA (Arbitrary Remote Initiated Actions)"
  - ARiA controls whether keyboard automation commands are processed
  - Protocol version is negotiated based on client request (v4 or v4.5)

- **RIA (Remote Initiated Actions) Navigation** 
  
  - Client sends complete action scripts (e.g., `sndKeys(!mb!^%q)`)
  - No server-side mapping needed - client controls everything
  - 
  - Focus control prefixes:
    - `!mb!` - Explicitly focus MusicBee (default)
    - `!nofocus!` - Send keys to current focused window

- **Enhanced SendKeys Support**
  
  - Complete .NET SendKeys notation documentation
  - Support for all modifier keys (Ctrl, Alt, Shift, Win)
  - Function keys F1-F24
  - System keys (Print Screen, Caps Lock, etc.)
  - Application launching examples

### Changed

- Protocol version negotiated based on client request (v4 → v4.0, v4.5+ → v4.5)
- Tab navigation renamed to RIA (Remote Initiated Actions)
- Default action scripts now use `!mb!` prefix for explicit MusicBee focus
- ARiA setting stored in `mb_remote\settings.xml` as `<aria_enabled>` node

### Security

- ARiA disabled by default - requires explicit user consent
- All remote keyboard actions blocked when ARiA is disabled
- Standard music controls continue to work regardless of ARiA setting
- Comprehensive security documentation and warnings

### Documentation

- Complete ARiA system documentation in `ARBITRARY_COMMAND_SYSTEM.md`
- Security implications and risk mitigation strategies
- Full SendKeys notation reference
- Application launching and automation examples

### Known Issues

- Visualizer interface commands are not yet functional
  - `playervisualizer` and `playervisualizerlist` commands implemented but not working
  - MusicBee API integration for visualizers pending

## 1.4.2 - 2025/08/11

## 1.4.1 - 2021/06/12

### Changed

- Introduces state persistence for the cover caching mechanism to improve performance.

### Added

- Adds a button in the control panel to allow for easy cache invalidation.

## 1.4.0

### Changed

- Fixes status displaying as stopped when range filtering is active.
- Adds pagination to the radio station api
- Adds support for different behavior on different client platforms (Android/iOS)
- Fixes repeat one functionality.
- Fixes issue with lyrics initialization on direct request.
- Fixes off by one now playing play on Android clients
- Adds Album Artist info to `nowplayinglist` and `libraryalbumtracks` commands.

### Added

- Adds support for requesting list of Album Artists instead of Artists.
- Adds support for shuffle/non-shuffle play all command. 
- Adds support for Album covers.

## 1.3.0-ios

### Changed

- Adds disk number to `libraryalbumtracks`.

### Added

- Introduces tag manipulation command.

## 1.2.1-ios

### Changed

- Introduces ordering into the now playing list and a limit of 100 entries.

## 1.2.0-ios

### Changed

- Allows the reset of a track's rating by sending an empty string.

### Added

- Introduces support for playing track details.

## 1.1.0

- Adds a check to avoid a case where invalid characters in the tags would result in a sync failure.
- Adds a proper socket checker to update the status.
- Fixes an issue with the rating when using specific locales (like German)
- Fixes an issue with the favorite state not updating properly when changing tracks
- Adds protocol support for switching audio outputs
- Adds protocol support for getting Radio Stations

## 1.0.0

- Adds new API for playlist retrieval.
- Adds new API for now playing that works with pagination.
- Removed settings for now playing. The old call is now hard limited to 5000 (will be deprecated).
- Adds debug checkbox on the Plugin settings options menu.
- Adds settings button to easily open the log.
- Makes the discovery listen to all available interfaces.
- Adds new paginated API to enable library browsing.
- Fixes an issue where the last.fm love status was the opposite of the expected.
