using System.Collections.Generic;
using System.Linq;
using MusicBeePlugin.AndroidRemote.Entities;
using MusicBeePlugin.AndroidRemote.Events;
using MusicBeePlugin.AndroidRemote.Model;
using MusicBeePlugin.AndroidRemote.Model.Entities;
using MusicBeePlugin.AndroidRemote.Networking;
using NLog;
using static MusicBeePlugin.Plugin;

namespace MusicBeePlugin.AndroidRemote.Services
{
    /// <summary>
    /// Handles radio station operations.
    /// Extracted from Plugin.cs to reduce monolith size.
    /// </summary>
    public class RadioService
    {
        private readonly Logger _logger = LogManager.GetCurrentClassLogger();

        public RadioService()
        {
        }

        /// <summary>
        /// Request list of radio stations.
        /// </summary>
        public void RequestRadioStations(string clientId, int offset = 0, int limit = 4000)
        {
            var api = Plugin.Instance.MbApiInterface;
            var radioStations = new string[] { };
            var success = api.Library_QueryFilesEx("domain=Radio", out radioStations);
            List<RadioStation> stations;
            if (success)
                stations = radioStations.Select(s => new RadioStation
                {
                    Url = s,
                    Name = api.Library_GetFileTag(s, MetaDataType.TrackTitle)
                })
                    .ToList();
            else
                stations = new List<RadioStation>();

            var total = stations.Count;
            var realLimit = offset + limit > total ? total - offset : limit;
            var message = new SocketMessage
            {
                Context = Constants.RadioStations,
                Data = new Page<RadioStation>
                {
                    Data = offset > total ? new List<RadioStation>() : stations.GetRange(offset, realLimit),
                    Offset = offset,
                    Limit = limit,
                    Total = total
                }
            };

            SendReply(message.ToJsonString(), clientId);
        }
    }
}
