using MusicBeePlugin.AndroidRemote.Enumerations;
using NLog;

namespace MusicBeePlugin.AndroidRemote.Services
{
    /// <summary>
    /// Handles queue operations for the now playing list.
    /// Extracted from Plugin.cs to reduce monolith size.
    /// </summary>
    public class QueueService
    {
        private readonly Logger _logger = LogManager.GetCurrentClassLogger();

        public QueueService()
        {
        }

        /// <summary>
        /// Queues files to the now playing list.
        /// </summary>
        /// <param name="queue">Queue position type</param>
        /// <param name="data">Array of file paths</param>
        /// <param name="query">Optional: specific file to play</param>
        /// <returns>True if successful</returns>
        public bool QueueFiles(QueueType queue, string[] data, string query = "")
        {
            var api = Plugin.Instance.MbApiInterface;
            switch (queue)
            {
                case QueueType.Next:
                    return api.NowPlayingList_QueueFilesNext(data);
                case QueueType.Last:
                    return api.NowPlayingList_QueueFilesLast(data);
                case QueueType.PlayNow:
                    if (data == null || data.Length == 0) return false;
                    api.NowPlayingList_Clear();
                    api.NowPlayingList_QueueFilesLast(data);
                    return api.NowPlayingList_PlayNow(data[0]);
                case QueueType.AddAndPlay:
                    api.NowPlayingList_Clear();
                    api.NowPlayingList_QueueFilesLast(data);
                    return api.NowPlayingList_PlayNow(query);
                default:
                    return false;
            }
        }
    }
}
