﻿using System;
using System.Runtime.Serialization;

namespace MusicBeePlugin.AndroidRemote.Model.Entities
{
    [DataContract]
    internal class Track : IEquatable<Track>, IComparable<Track>
    {
        public Track()
        {
        }

        public Track(string artist, string title, int trackNo, string src)
        {
            Artist = artist;
            Title = title;
            Src = src;
            TrackNo = trackNo;
        }

        [DataMember(Name = "src")] public string Src { get; set; }

        [DataMember(Name = "artist")] public string Artist { get; set; }

        [DataMember(Name = "title")] public string Title { get; set; }

        [DataMember(Name = "trackno")] public int TrackNo { get; set; }

        [DataMember(Name = "disc")] public int Disc { get; set; }

        [DataMember(Name = "album")] public string Album { get; set; }

        [DataMember(Name = "album_artist")] public string AlbumArtist { get; set; }

        [DataMember(Name = "genre")] public string Genre { get; set; }

        // Extended metadata fields - v4.5+ only (EmitDefaultValue=false omits when null/0)
        [DataMember(Name = "year", EmitDefaultValue = false)] public string Year { get; set; }

        [DataMember(Name = "rating", EmitDefaultValue = false)] public string Rating { get; set; }

        [DataMember(Name = "bitrate", EmitDefaultValue = false)] public string Bitrate { get; set; }

        [DataMember(Name = "format", EmitDefaultValue = false)] public string Format { get; set; }

        [DataMember(Name = "playcount", EmitDefaultValue = false)] public int PlayCount { get; set; }

        [DataMember(Name = "lastplayed", EmitDefaultValue = false)] public string LastPlayed { get; set; }

        [DataMember(Name = "skipcount", EmitDefaultValue = false)] public int SkipCount { get; set; }

        [DataMember(Name = "dateadded", EmitDefaultValue = false)] public string DateAdded { get; set; }

        /// <summary>
        /// Love status: "L" = Loved, "B" = Banned, "" = Neither
        /// Maps from MusicBee's RatingLove tag (Llfm/Blfm/empty)
        /// </summary>
        [DataMember(Name = "loved", EmitDefaultValue = false)] public string Loved { get; set; }

        public int CompareTo(Track other)
        {
            return other == null ? 1 : TrackNo.CompareTo(other.TrackNo);
        }

        public bool Equals(Track other)
        {
            return other != null && other.Artist.Equals(Artist) && other.Title.Equals(Title);
        }
    }
}