using System.Runtime.Serialization;

namespace MusicBeePlugin.AndroidRemote.Model.Entities
{
    /// <summary>
    /// Represents a podcast episode from MusicBee.
    /// </summary>
    [DataContract]
    public class PodcastEpisode
    {
        [DataMember(Name = "id")]
        public string Id { get; set; }

        [DataMember(Name = "subscriptionId")]
        public string SubscriptionId { get; set; }

        [DataMember(Name = "title")]
        public string Title { get; set; }

        [DataMember(Name = "dateTime")]
        public string DateTime { get; set; }

        [DataMember(Name = "description")]
        public string Description { get; set; }

        [DataMember(Name = "duration")]
        public string Duration { get; set; }

        [DataMember(Name = "isDownloaded")]
        public bool IsDownloaded { get; set; }

        [DataMember(Name = "hasBeenPlayed")]
        public bool HasBeenPlayed { get; set; }

        [DataMember(Name = "url")]
        public string Url { get; set; }
    }
}
