using MusicBeePlugin.AndroidRemote.ARiA;
using NLog;

namespace MusicBeePlugin.AndroidRemote.Commands
{
    /// <summary>
    /// Protocol handler for initiator action messages.
    /// Delegates execution to ARiA (Arbitrary Remote Initiated Actions).
    /// </summary>
    public class InitiatorActionHandler
    {
        private static readonly Logger Logger = LogManager.GetCurrentClassLogger();
        private readonly AriaCommandExecutor _executor;

        public InitiatorActionHandler(Plugin.MusicBeeApiInterface api)
        {
            _executor = new AriaCommandExecutor
            {
                GetWindowHandle = () => api.MB_GetWindowHandle(),
                GetInstallPath = () => api.MB_GetInstallPath(),
                RequestApplicationClose = () => api.MB_SendNotification(Plugin.CallbackType.ApplicationClose)
            };
        }

        public bool ExecuteActionScript(string actionScript)
        {
            return _executor.ExecuteScript(actionScript);
        }
    }
}
