﻿using MusicBeePlugin.AndroidRemote.Interfaces;

namespace MusicBeePlugin.AndroidRemote.Events
{
    internal class MessageEvent : IEvent
    {
        public MessageEvent(string type, object data)
        {
            Data = data;
            Type = type;
            ClientId = "all";
            ExtraData = string.Empty;
        }

        public MessageEvent(string type, object data, string clientId)
        {
            Type = type;
            Data = data;
            ClientId = clientId;
            ExtraData = string.Empty;
        }

        public MessageEvent(string type)
        {
            Type = type;
            Data = ExtraData = string.Empty;
            ClientId = string.Empty;
        }

        public string DataToString()
        {
            if (Data is string s) return s;
            if (Data == null) return string.Empty;
            if (Data is Newtonsoft.Json.Linq.JValue jv)
            {
                return jv.Value?.ToString() ?? string.Empty;
            }
            return Data.ToString() ?? string.Empty;
        }

        public object Data { get; }

        public string Type { get; }

        public string ClientId { get; }

        public string ExtraData { get; }
    }
}