﻿using MusicBeePlugin.AndroidRemote.Commands;
using MusicBeePlugin.AndroidRemote.Commands.InstaReplies;
using MusicBeePlugin.AndroidRemote.Commands.Internal;
using MusicBeePlugin.AndroidRemote.Commands.Requests;
using MusicBeePlugin.AndroidRemote.Commands.State;
using MusicBeePlugin.AndroidRemote.Events;
using MusicBeePlugin.AndroidRemote.Networking;

namespace MusicBeePlugin.AndroidRemote
{
    internal static class Configuration
    {
        public static void Register(Controller.Controller controller)
        {
            controller.AddCommand(EventType.ActionSocketStart, typeof(StartSocketServer));
            controller.AddCommand(EventType.ActionSocketStop, typeof(StopSocketServer));
            controller.AddCommand(EventType.ActionClientConnected, typeof(ClientConnected));
            controller.AddCommand(EventType.ActionClientDisconnected, typeof(ClientDisconnected));
            controller.AddCommand(EventType.ActionForceClientDisconnect, typeof(ForceClientDisconnect));
            controller.AddCommand(EventType.InitializeModel, typeof(InitializeModelStateCommand));
            controller.AddCommand(EventType.NowPlayingCoverChange, typeof(PCoverChanged));
            controller.AddCommand(EventType.NowPlayingLyricsChange, typeof(PLyricsChanged));
            controller.AddCommand(EventType.StartServiceBroadcast, typeof(StartServiceBroadcast));
            controller.AddCommand(EventType.SocketStatusChange, typeof(SocketStatusChanged));
            controller.AddCommand(EventType.RestartSocket, typeof(RestartSocketCommand));
            controller.AddCommand(EventType.ShowFirstRunDialog, typeof(ShowFirstRunDialogCommand));
            /** Protocol Related commands **/
            controller.AddCommand(Constants.Player, typeof(RequestPlayer));
            controller.AddCommand(Constants.Protocol, typeof(RequestProtocol));
            controller.AddCommand(Constants.PluginVersion, typeof(RequestPluginVersion));
            controller.AddCommand(Constants.PluginInstanceId, typeof(RequestPluginInstanceId));
            controller.AddCommand(Constants.PlaylistList, typeof(RequestPlaylistList));
            controller.AddCommand(Constants.PlayerNext, typeof(RequestNextTrack));
            controller.AddCommand(Constants.PlayerPlayPause, typeof(RequestPlayPause));
            controller.AddCommand(Constants.PlayerPrevious, typeof(RequestPreviousTrack));
            controller.AddCommand(Constants.PlayerStop, typeof(RequestStop));
            controller.AddCommand(Constants.PlayerVolume, typeof(RequestVolume));
            controller.AddCommand(Constants.PlayerStatus, typeof(RequestPlayerStatus));
            controller.AddCommand(Constants.PlayerAutoDj, typeof(RequestAutoDj));
            controller.AddCommand(Constants.PlayerShuffle, typeof(RequestShuffle));
            controller.AddCommand(Constants.PlayerScrobble, typeof(RequestScrobble));
            controller.AddCommand(Constants.PlayerRepeat, typeof(RequestRepeat));
            controller.AddCommand(Constants.PlayerMute, typeof(RequestMute));
            controller.AddCommand(Constants.PlayerInitiatorAction, typeof(RequestInitiatorAction));
            controller.AddCommand(Constants.PlayerVisualizer, typeof(RequestVisualizer));
            controller.AddCommand(Constants.PlayerVisualizerList, typeof(RequestVisualizerList));
            controller.AddCommand(Constants.NowPlayingPosition, typeof(RequestPlaybackPosition));
            controller.AddCommand(Constants.NowPlayingListRemove, typeof(RequestNowPlayingTrackRemoval));
            controller.AddCommand(Constants.NowPlayingListPlay, typeof(RequestNowPlayingPlay));
            controller.AddCommand(Constants.NowPlayingList, typeof(RequestNowPlayingList));
            controller.AddCommand(Constants.NowPlayingLfmRating, typeof(RequestLfmLoveRating));
            controller.AddCommand(Constants.NowPlayingTrack, typeof(RequestSongInfo));
            controller.AddCommand(Constants.NowPlayingCover, typeof(RequestCover));
            controller.AddCommand(Constants.NowPlayingLyrics, typeof(RequestLyrics));
            controller.AddCommand(Constants.NowPlayingRating, typeof(RequestRating));
            controller.AddCommand(Constants.NowPlayingListSearch, typeof(RequestNowPlayingSearch));
            controller.AddCommand(Constants.NowPlayingListMove, typeof(RequestNowPlayingMoveTrack));
            controller.AddCommand(Constants.LibrarySearchArtist, typeof(RequestLibSearchArtist));
            controller.AddCommand(Constants.LibrarySearchAlbum, typeof(RequestLibSearchAlbum));
            controller.AddCommand(Constants.LibrarySearchGenre, typeof(RequestLibSearchGenre));
            controller.AddCommand(Constants.LibrarySearchTitle, typeof(RequestLibSearchTitle));
            controller.AddCommand(Constants.LibraryQueueAlbum, typeof(RequestLibQueueAlbum));
            controller.AddCommand(Constants.LibraryQueueArtist, typeof(RequestLibQueueArtist));
            controller.AddCommand(Constants.LibraryQueueGenre, typeof(RequestLibQueueGenre));
            controller.AddCommand(Constants.LibraryQueueTrack, typeof(RequestLibQueueTrack));
            controller.AddCommand(EventType.ReplyAvailable, typeof(ReplayAvailable));
            controller.AddCommand(Constants.LibraryArtistAlbums, typeof(RequestLibArtistAlbums));
            controller.AddCommand(Constants.LibraryAlbumTracks, typeof(RequestLibAlbumTracks));
            controller.AddCommand(Constants.LibraryGenreArtists, typeof(RequestLibGenreArtists));

            #region Protocol 2.1

            controller.AddCommand(Constants.Pong, typeof(HandlePong));
            controller.AddCommand(Constants.Ping, typeof(PingReply));
            controller.AddCommand(Constants.Init, typeof(ProcessInitRequest));
            controller.AddCommand(Constants.PlayerPlay, typeof(RequestPlay));
            controller.AddCommand(Constants.PlayerPause, typeof(RequestPause));

            #endregion

            #region Protocol 3

            controller.AddCommand(Constants.PlaylistPlay, typeof(RequestPlaylistPlay));
            controller.AddCommand(Constants.PlaylistQueue, typeof(RequestPlaylistQueue));
            controller.AddCommand(Constants.LibraryBrowseGenres, typeof(RequestBrowseGenres));
            controller.AddCommand(Constants.LibraryBrowseArtists, typeof(RequestBrowseArtists));
            controller.AddCommand(Constants.LibraryBrowseAlbums, typeof(RequestBrowseAlbums));
            controller.AddCommand(Constants.LibraryBrowseTracks, typeof(RequestBrowseTracks));
            controller.AddCommand(EventType.BroadcastEvent, typeof(BroadcastEventAvailable));
            controller.AddCommand(Constants.NowPlayingQueue, typeof(RequestNowPlayingQueue));

            #endregion

            #region Protocol 4

            controller.AddCommand(Constants.PlayerOutput, typeof(RequestOutputDeviceList));
            controller.AddCommand(Constants.PlayerOutputSwitch, typeof(RequestPlayerOutputSwitch));
            controller.AddCommand(Constants.RadioStations, typeof(RequestRadioStations));

            controller.AddCommand(Constants.NowPlayingDetails, typeof(RequestSongDetails));
            controller.AddCommand(Constants.NowPlayingTagChange, typeof(RequestTagChange));
            controller.AddCommand(Constants.LibraryPlayAll, typeof(RequestLibPlayAll));
            controller.AddCommand(Constants.LibraryAlbumCover, typeof(RequestLibraryAlbumCover));
            controller.AddCommand(Constants.LibraryCoverCacheBuildStatus, typeof(RequestCoverCacheBuildStatus));

            #endregion

            #region Protocol 5 - MusicBee 3.1+ Features

            // Album Navigation (API 50)
            controller.AddCommand(Constants.PlayerPreviousAlbum, typeof(RequestPreviousAlbum));
            controller.AddCommand(Constants.PlayerNextAlbum, typeof(RequestNextAlbum));

            // Podcasts (API 51)
            controller.AddCommand(Constants.PodcastSubscriptions, typeof(RequestPodcastSubscriptions));
            controller.AddCommand(Constants.PodcastEpisodes, typeof(RequestPodcastEpisodes));
            controller.AddCommand(Constants.PodcastPlay, typeof(RequestPodcastPlay));

            // Storage Path (v4.5, requires ARiA enabled)
            controller.AddCommand(Constants.PluginStoragePath, typeof(RequestStoragePath));

            // Library Track Metadata Editing (v4.5 - Two-Way Sync)
            controller.AddCommand(Constants.LibrarySetRating, typeof(RequestLibrarySetRating));
            controller.AddCommand(Constants.LibrarySetLove, typeof(RequestLibrarySetLove));

            // Library Event Subscriptions (v4.5 - Real-time Sync)
            controller.AddCommand(Constants.LibrarySubscribe, typeof(RequestLibrarySubscribe));
            controller.AddCommand(Constants.LibraryUnsubscribe, typeof(RequestLibraryUnsubscribe));

            // ARiA Hotkey Configuration (v4.5 - Remote hotkey setup)
            controller.AddCommand(Constants.ConfigureAriaHotkeys, typeof(RequestConfigureAriaHotkeys));

            #endregion
        }
    }
}