using MusicBeePlugin.AndroidRemote.Interfaces;
using MusicBeePlugin.AndroidRemote.Settings;

namespace MusicBeePlugin.AndroidRemote.Commands.Requests
{
    /// <summary>
    /// Handles requests to get the list of available visualizers
    /// </summary>
    internal class RequestVisualizerList : ICommand
    {
        public void Execute(IEvent e)
        {
            // Check if experimental features are enabled
            if (!UserSettings.Instance.ExperimentalFeaturesEnabled)
            {
                Plugin.Instance.SendVisualizerNotEnabled(e.ClientId, forListRequest: true);
                return;
            }

            Plugin.Instance.RequestVisualizerList(e.ClientId);
        }
    }
}