using MusicBeePlugin.AndroidRemote.Interfaces;
using MusicBeePlugin.AndroidRemote.Settings;
using Newtonsoft.Json.Linq;

namespace MusicBeePlugin.AndroidRemote.Commands.Requests
{
    /// <summary>
    /// Handles requests to show/control a visualizer
    /// </summary>
    internal class RequestVisualizer : ICommand
    {
        public void Execute(IEvent e)
        {
            // Check if experimental features are enabled
            if (!UserSettings.Instance.ExperimentalFeaturesEnabled)
            {
                Plugin.Instance.SendVisualizerNotEnabled(e.ClientId);
                return;
            }

            if (e.Data == null)
            {
                Plugin.Instance.RequestVisualizer("", "off", e.ClientId);
                return;
            }

            string visualizerName = null;
            string state = "normal";

            // Handle data that can be either string or object
            if (e.Data is string dataString)
            {
                // Simple string format: "VisualizerName" or "VisualizerName:State"
                var parts = dataString.Split(':');
                visualizerName = parts[0];
                if (parts.Length > 1)
                {
                    state = parts[1];
                }
            }
            else if (e.Data is JObject jObject)
            {
                // Handle JObject directly
                visualizerName = jObject["name"]?.ToString();
                state = jObject["state"]?.ToString() ?? "normal";
            }
            else
            {
                // Try to handle ServiceStack.Text.JsonObject or other dynamic types
                try
                {
                    dynamic dataObject = e.Data;
                    visualizerName = dataObject.name?.ToString() ?? dataObject.Name?.ToString();
                    state = dataObject.state?.ToString() ?? dataObject.State?.ToString() ?? "normal";
                }
                catch
                {
                    // Last resort - convert to string
                    visualizerName = e.Data.ToString();
                }
            }

            Plugin.Instance.RequestVisualizer(visualizerName ?? "", state, e.ClientId);
        }
    }
}