﻿using MusicBeePlugin.AndroidRemote.Interfaces;
using MusicBeePlugin.AndroidRemote.Model.Entities;
using MusicBeePlugin.AndroidRemote.Networking;
using MusicBeePlugin.AndroidRemote.Utilities;

namespace MusicBeePlugin.AndroidRemote.Commands.Requests
{
    internal class RequestProtocol : ICommand
    {
        public void Execute(IEvent eEvent)
        {
            // Client's protocol version is already parsed and stored by ProtocolHandler
            var clientProtocolVersion = Authenticator.ClientProtocolVersion(eEvent.ClientId);

            // Protocol negotiation for backward compatibility:
            // Client requests v4 → respond v4.0 (no extended metadata, no breaking change)
            // Client requests v4.5+ → respond v4.5 (extended metadata, ARiA if enabled)
            double negotiatedVersion = clientProtocolVersion >= 4.5
                ? Constants.ProtocolVersionWithAria  // 4.5
                : Constants.ProtocolVersion;         // 4.0

            SocketServer.Instance.Send(new SocketMessage(Constants.Protocol, negotiatedVersion).ToJsonString(),
                eEvent.ClientId);
        }
    }
}