using MusicBeePlugin.AndroidRemote.Interfaces;

namespace MusicBeePlugin.AndroidRemote.Commands.Requests
{
    /// <summary>
    /// Handles the podcastplay command to play a podcast episode.
    /// Requires MusicBee API 51+ (v3.1+).
    /// </summary>
    internal class RequestPodcastPlay : ICommand
    {
        public void Execute(IEvent eEvent)
        {
            var episodeUrl = eEvent.Data as string ?? eEvent.DataToString();
            Plugin.Instance.RequestPodcastPlay(eEvent.ClientId, episodeUrl);
        }
    }
}
