using MusicBeePlugin.AndroidRemote.Interfaces;
using MusicBeePlugin.AndroidRemote.Utilities;

namespace MusicBeePlugin.AndroidRemote.Commands.Requests
{
    /// <summary>
    /// Handles the podcastepisodes command to get episodes for a subscription.
    /// Requires MusicBee API 51+ (v3.1+).
    /// </summary>
    internal class RequestPodcastEpisodes : ICommand
    {
        public void Execute(IEvent eEvent)
        {
            var subscriptionId = eEvent.Data as string ?? eEvent.DataToString();
            Plugin.Instance.RequestPodcastEpisodes(eEvent.ClientId, subscriptionId);
        }
    }
}
