using MusicBeePlugin.AndroidRemote.Interfaces;
using MusicBeePlugin.AndroidRemote.Model.Entities;
using MusicBeePlugin.AndroidRemote.Networking;
using MusicBeePlugin.AndroidRemote.Settings;

namespace MusicBeePlugin.AndroidRemote.Commands.Requests
{
    /// <summary>
    /// Returns the unique instance ID for this plugin installation.
    /// Clients use this to detect when connecting to a different server.
    /// </summary>
    internal class RequestPluginInstanceId : ICommand
    {
        public void Execute(IEvent eEvent)
        {
            SocketServer.Instance.Send(new SocketMessage(Constants.PluginInstanceId, UserSettings.Instance.InstanceId)
                .ToJsonString());
        }
    }
}
