using System;
using MusicBeePlugin.AndroidRemote.Interfaces;
using MusicBeePlugin.AndroidRemote.Model.Entities;
using MusicBeePlugin.AndroidRemote.Networking;
using MusicBeePlugin.AndroidRemote.Subscriptions;
using NLog;

namespace MusicBeePlugin.AndroidRemote.Commands.Requests
{
    /// <summary>
    /// Unsubscribes a client from library event notifications.
    /// Request: {} (no parameters needed)
    /// Response: { "success": true }
    /// </summary>
    internal class RequestLibraryUnsubscribe : ICommand
    {
        private static readonly Logger Logger = LogManager.GetCurrentClassLogger();

        public void Execute(IEvent eEvent)
        {
            try
            {
                var wasSubscribed = LibrarySubscriptionManager.Instance.Unsubscribe(eEvent.ClientId);

                Logger.Info("Client {0} unsubscribed from library events (wasSubscribed={1})",
                    eEvent.ClientId, wasSubscribed);

                Plugin.SendReply(
                    new SocketMessage(Constants.LibraryUnsubscribe,
                        new { success = true, wasSubscribed }).ToJsonString(),
                    eEvent.ClientId);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Error in RequestLibraryUnsubscribe");
                Plugin.SendReply(
                    new SocketMessage(Constants.LibraryUnsubscribe,
                        new { success = false, error = ex.Message }).ToJsonString(),
                    eEvent.ClientId);
            }
        }
    }
}
