﻿using System.Collections.Generic;
using MusicBeePlugin.AndroidRemote.Enumerations;
using MusicBeePlugin.AndroidRemote.Interfaces;
using NLog;
using ServiceStack.Text;

namespace MusicBeePlugin.AndroidRemote.Commands.Requests
{
    internal class RequestLibQueueTrack : ICommand
    {
        private static readonly Logger Logger = LogManager.GetCurrentClassLogger();

        public void Execute(IEvent eEvent)
        {
            string type = null;
            string query = null;

            Logger.Debug($"RequestLibQueueTrack: Data type = {eEvent.Data?.GetType()?.Name ?? "null"}");

            // Handle both Dictionary and JsonObject/JObject types
            if (eEvent.Data is Dictionary<string, string> dict)
            {
                dict.TryGetValue("type", out type);
                dict.TryGetValue("query", out query);
                Logger.Debug($"RequestLibQueueTrack: Parsed as Dictionary - type={type}, query={query}");
            }
            else if (eEvent.Data is JsonObject jsonObj)
            {
                type = jsonObj.Get<string>("type");
                query = jsonObj.Get<string>("query");
                Logger.Debug($"RequestLibQueueTrack: Parsed as JsonObject - type={type}, query={query}");
            }
            else if (eEvent.Data is Newtonsoft.Json.Linq.JObject jObj)
            {
                type = jObj["type"]?.ToString();
                query = jObj["query"]?.ToString();
                Logger.Debug($"RequestLibQueueTrack: Parsed as JObject - type={type}, query={query}");
            }
            else
            {
                Logger.Warn($"RequestLibQueueTrack: Unknown data type: {eEvent.Data?.GetType()?.FullName}");
            }

            QueueType qType;
            switch (type)
            {
                case "next":
                    qType = QueueType.Next;
                    break;
                case "last":
                    qType = QueueType.Last;
                    break;
                case "now":
                    qType = QueueType.PlayNow;
                    break;
                default:
                    qType = QueueType.Next;
                    Logger.Warn($"RequestLibQueueTrack: Unknown type '{type}', defaulting to Next");
                    break;
            }

            Logger.Debug($"RequestLibQueueTrack: Calling RequestQueueFiles with qType={qType}, query={query}");
            Plugin.Instance.RequestQueueFiles(qType, MetaTag.Title, query);
        }
    }
}