namespace Mbrcpval.Testing;

/// <summary>
/// Represents the final status of a test execution.
/// </summary>
public enum TestStatus
{
    /// <summary>
    /// The test passed all assertions successfully.
    /// </summary>
    Pass,

    /// <summary>
    /// The test failed one or more assertions.
    /// </summary>
    Fail,

    /// <summary>
    /// The test was skipped (prerequisites not met or explicitly skipped).
    /// </summary>
    Skip,

    /// <summary>
    /// The test encountered an error during execution (not an assertion failure).
    /// </summary>
    Error
}
