namespace Mbrcpval.Testing;

/// <summary>
/// Defines the type of action to perform in a test step.
/// </summary>
public enum StepAction
{
    /// <summary>
    /// Establish a connection to the MBRC server.
    /// </summary>
    Connect,

    /// <summary>
    /// Disconnect from the MBRC server.
    /// </summary>
    Disconnect,

    /// <summary>
    /// Send a message to the MBRC server.
    /// </summary>
    Send,

    /// <summary>
    /// Wait to receive a specific message from the server.
    /// </summary>
    Receive,

    /// <summary>
    /// Receive any message from the server (non-specific).
    /// </summary>
    ReceiveAny,

    /// <summary>
    /// Wait for a specified duration.
    /// </summary>
    Wait,

    /// <summary>
    /// Assert a condition without sending/receiving.
    /// </summary>
    Assert,

    /// <summary>
    /// Set a variable for use in later steps.
    /// </summary>
    SetVariable,

    /// <summary>
    /// Log a message for debugging purposes.
    /// </summary>
    Log
}
