namespace Mbrcpval.Testing;

/// <summary>
/// Defines the type of assertion to perform when validating message content.
/// </summary>
public enum AssertionType
{
    /// <summary>
    /// Assert that the actual value equals the expected value.
    /// </summary>
    Equals,

    /// <summary>
    /// Assert that the actual value does not equal the expected value.
    /// </summary>
    NotEquals,

    /// <summary>
    /// Assert that the actual value contains the expected value (for strings/arrays).
    /// </summary>
    Contains,

    /// <summary>
    /// Assert that the actual value does not contain the expected value.
    /// </summary>
    NotContains,

    /// <summary>
    /// Assert that the actual value matches a regular expression pattern.
    /// </summary>
    Matches,

    /// <summary>
    /// Assert that a value exists at the specified path.
    /// </summary>
    Exists,

    /// <summary>
    /// Assert that no value exists at the specified path.
    /// </summary>
    NotExists,

    /// <summary>
    /// Assert that the actual value is greater than the expected value.
    /// </summary>
    GreaterThan,

    /// <summary>
    /// Assert that the actual value is less than the expected value.
    /// </summary>
    LessThan,

    /// <summary>
    /// Assert that the actual value is greater than or equal to the expected value.
    /// </summary>
    GreaterOrEqual,

    /// <summary>
    /// Assert that the actual value is less than or equal to the expected value.
    /// </summary>
    LessOrEqual,

    /// <summary>
    /// Assert that the actual value is of a specific type.
    /// </summary>
    IsType,

    /// <summary>
    /// Assert that the value conforms to a JSON schema.
    /// </summary>
    SchemaValid
}
