namespace Mbrcpval.Core;

/// <summary>
/// Types of validation errors that can occur during schema validation.
/// </summary>
public enum ValidationErrorType
{
    /// <summary>
    /// A required field is missing from the JSON object.
    /// </summary>
    MissingRequiredField,

    /// <summary>
    /// The value type does not match the expected type in the schema.
    /// </summary>
    InvalidType,

    /// <summary>
    /// The value does not match the allowed values (e.g., enum constraint).
    /// </summary>
    InvalidValue,

    /// <summary>
    /// The value does not match the required format (e.g., pattern, date format).
    /// </summary>
    InvalidFormat,

    /// <summary>
    /// An additional property was found that is not allowed by the schema.
    /// </summary>
    AdditionalProperty,

    /// <summary>
    /// The requested schema was not found in the registry.
    /// </summary>
    SchemaNotFound,

    /// <summary>
    /// The JSON could not be parsed.
    /// </summary>
    ParseError
}
