namespace Mbrcpval.Core;

/// <summary>
/// Direction of message flow in the MBRC protocol.
/// </summary>
public enum MessageDirection
{
    /// <summary>
    /// Request message from client to server.
    /// </summary>
    Request,

    /// <summary>
    /// Response message from server to client.
    /// </summary>
    Response,

    /// <summary>
    /// Event message broadcast from server to connected clients.
    /// </summary>
    Event,

    /// <summary>
    /// UDP discovery message for server discovery.
    /// </summary>
    Discovery
}
