namespace Mbrcpval.Core;

/// <summary>
/// Represents the connection state of an MBRC client.
/// </summary>
public enum ConnectionState
{
    /// <summary>
    /// Not connected to the server.
    /// </summary>
    Disconnected,

    /// <summary>
    /// TCP connection is being established.
    /// </summary>
    Connecting,

    /// <summary>
    /// TCP connection established, handshake not started.
    /// </summary>
    Connected,

    /// <summary>
    /// Handshaking: waiting for player context response.
    /// </summary>
    HandshakingPlayer,

    /// <summary>
    /// Handshaking: waiting for protocol context response.
    /// </summary>
    HandshakingProtocol,

    /// <summary>
    /// Handshaking: waiting for init context response.
    /// </summary>
    HandshakingInit,

    /// <summary>
    /// Fully connected and handshake complete. Ready for commands.
    /// </summary>
    Ready,

    /// <summary>
    /// An error occurred. Connection should be reset.
    /// </summary>
    Error
}
