using System.ComponentModel;
using Spectre.Console;
using Spectre.Console.Cli;

namespace Mbrcpval.CLI.Settings;

/// <summary>
/// Base settings class with common options shared across all commands.
/// </summary>
public class CommonSettings : CommandSettings
{
    /// <summary>
    /// Enable verbose output for detailed logging and debugging.
    /// </summary>
    [CommandOption("-v|--verbose")]
    [Description("Enable verbose output for detailed logging")]
    [DefaultValue(false)]
    public bool Verbose { get; set; }

    /// <summary>
    /// Disable colored output for CI/CD environments or piping.
    /// </summary>
    [CommandOption("--no-color")]
    [Description("Disable colored output")]
    [DefaultValue(false)]
    public bool NoColor { get; set; }

    /// <summary>
    /// Suppress non-essential output (quiet mode).
    /// </summary>
    [CommandOption("-q|--quiet")]
    [Description("Suppress non-essential output")]
    [DefaultValue(false)]
    public bool Quiet { get; set; }

    /// <summary>
    /// Validate the settings.
    /// </summary>
    public override ValidationResult Validate()
    {
        // Quiet and Verbose are mutually exclusive
        if (Quiet && Verbose)
        {
            return ValidationResult.Error("Cannot use both --quiet and --verbose simultaneously");
        }

        return ValidationResult.Success();
    }
}
