# MBRCPVAL Changelog

All notable changes to MBRCPVAL will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

> **Related Documentation:**
> - [Overview](MBRCPVAL-Overview.md) - What is MBRCPVAL?
> - [Quick Start](MBRCPVAL-QUICKSTART.md) - Getting started guide
> - [Full Specification](MBRCPVAL-SPEC.md) - Protocol specification

---

## [Unreleased]

### Planned
- GUI interface for visual test execution
- Wireshark dissector for MBRC protocol
- Protocol diff tool for version comparison
- Code generation from JSON schemas

---

## [1.5.26.3] - 2026-01-04

### Added
- **Plugin Settings Detection** - Header now displays ARiA and Experimental feature status
  - ARiA: Queries `pluginstoragepath` to detect enabled/disabled
  - Experimental: Queries `playervisualizerlist` to detect enabled/disabled
  - Shows "N/A (v4.5+)" for v4.0 plugins that don't support these features

### Fixed
- **v4.5 Test Assertions** - Corrected test expectations to match actual plugin responses
  - Protocol response returns version number directly (not nested object)
  - Removed incorrect `$.data.aria_enabled` and `$.data.experimental_enabled` checks
  - V45-011/012 now test actual ARiA and visualizer functionality
- **Handshake Sequence** - Protocol detection now uses correct packet order
  - Packet 0: `player` context (required)
  - Packet 1: `protocol` context (required)

### Validated
- Plugin v1.5.26.3 passes all protocol tests
  - v4.0: 24/24 tests passed
  - v4.5: All tests passed (ARiA + Experimental enabled)

---

## [1.0.0] - 2026-01-01

### Added

#### Core Features
- JSON Schema validation for all protocol messages (Draft 2020-12)
- TCP client with NDJSON framing and automatic reconnection
- Connection state machine with handshake sequence validation
- Schema-based message validation for requests, responses, and events

#### Test Framework
- YAML-based test case definitions
- Test runner with parallel execution support
- Assertion library with JSONPath support
- Test prerequisites and cleanup steps

#### Test Suites
- **Handshake** (HSK-001 to HSK-007): Connection sequence, protocol negotiation
- **Message Format** (MSG-001 to MSG-006): JSON structure, encoding, termination
- **Player Control** (PLY-001 to PLY-014): Play, pause, volume, shuffle, repeat
- **Now Playing** (NP-001 to NP-009): Track info, cover art, lyrics, position
- **Queue Operations** (QUE-001 to QUE-007): Add, remove, move, clear
- **Library Browse** (LIB-001 to LIB-008): Genres, artists, albums, tracks, search
- **v4.5 Features** (V45-001 to V45-007): Extended metadata, subscriptions
- **ARiA** (ARIA-001 to ARIA-005): Initiator actions (security-gated)
- **Discovery** (DSC-001 to DSC-005): UDP multicast protocol
- **Error Handling** (ERR-001 to ERR-007): Malformed input, timeouts
- **Performance** (PERF-001 to PERF-007): Latency, throughput, stress

#### Mock Server
- Full MBRC server emulation for client testing
- Configurable mock library (JSON file or random generation)
- Player state simulation (play, pause, stop, volume, shuffle, repeat)
- Library browse with pagination support
- Queue operations with track management

#### CLI Commands
- `mbrcpval server` - Validate server/plugin implementation
- `mbrcpval mock` - Start mock server for client testing
- `mbrcpval repl` - Interactive protocol explorer
- `mbrcpval proxy` - Passthrough proxy with traffic logging
- `mbrcpval validate` - Validate single message against schema

#### Report Formats
- **Text** - Console output with colored status indicators
- **JSON** - Machine-readable structured output
- **HTML** - Human-readable report with expandable details
- **JUnit** - CI/CD integration (GitHub Actions, Jenkins)

#### Protocol Support
- MBRC Protocol v4.0 (base functionality)
- MBRC Protocol v4.5 (extended metadata, subscriptions, two-way sync)
- UDP discovery protocol (multicast 239.1.5.10:45345)

### Technical Details

#### Dependencies
- .NET 8.0+
- NJsonSchema (JSON Schema validation)
- Newtonsoft.Json (JSON parsing)
- Spectre.Console (CLI framework)
- YamlDotNet (test case parsing)
- FsCheck (property-based testing)

#### JSON Schemas (40+ definitions)
- Common schemas: message, pagination, track
- Request schemas: player, protocol, init, playerplay, playerpause, etc.
- Response schemas: playerstatus, nowplayingtrack, browsetracks, etc.
- Event schemas: librarytagchanged, libraryratingchanged, etc.
- Discovery schemas: discovery-request, discovery-response

---

## Version History Summary

| Version | Date | Highlights |
|---------|------|------------|
| 1.5.26.3 | 2026-01-04 | Plugin settings detection, v4.5 test fixes |
| 1.0.0 | 2026-01-01 | Initial release with full test framework |

---

## Migration Notes

### Upgrading from Pre-release

If upgrading from a development version:

1. Test case format may have changed; re-validate custom YAML files
2. CLI arguments may have been renamed; check `mbrcpval --help`
3. JSON Schema paths may have changed; update any hardcoded references

---

## Contributing

When contributing changes:

1. Add entries to the [Unreleased] section
2. Use these categories: Added, Changed, Deprecated, Removed, Fixed, Security
3. Reference related issues/PRs where applicable
4. Follow the existing format

---

*Last Updated: 2026-01-04*
