# MBRC Protocol v4/4.5 SDK - Implementers Guide

**Protocol Versions:** v4.0 | v4.5

> This document is a markdown mirror of key sections from the HTML documentation at `tntctl/deploy/www/MBRC-Server-Plugin-Protocol.html`

---

## Table of Contents

1. [Protocol Fundamentals](#1-protocol-fundamentals)
2. [Service Discovery (UDP)](#2-service-discovery-udp)
3. [Connection & Handshake](#3-connection--handshake)
4. [Version Negotiation](#4-version-negotiation)
5. [Connection Commands](#5-connection-commands)
6. [Player Control Commands](#6-player-control-commands)
7. [Now Playing Commands](#7-now-playing-commands)
8. [Queue Commands](#8-queue-commands)
9. [Library Browse Commands](#9-library-browse-commands)
10. [Server Push Events](#10-server-push-events)
11. [Error Handling](#11-error-handling)
12. [Implementation Checklist](#12-implementation-checklist)

---

## 1. Protocol Fundamentals

### Message Format

All protocol communication uses **JSON over TCP** with **CRLF (`\r\n`) line termination**:

```json
{
  "context": "command_name",
  "data": {
    "field": "value"
  }
}
```

### Key Characteristics

| Property | Value |
|----------|-------|
| Encoding | UTF-8 **without BOM** |
| Line Termination | `\r\n` (CRLF - Windows style) |
| Message Boundary | One JSON message per line |
| Serialization | JSON (Newtonsoft.Json compatible) |
| Default Port | TCP 3000 (configurable) |
| Discovery | UDP Multicast 239.1.5.10:45345 |

---

## 2. Service Discovery (UDP)

### Discovery Request

Clients broadcast to multicast group `239.1.5.10:45345`:

```json
{
  "context": "discovery",
  "address": "192.168.1.100"
}
```

### Discovery Response

Servers respond with:

```json
{
  "context": "discovery",
  "address": "192.168.1.50:3000",
  "name": "MusicBee"
}
```

---

## 3. Connection & Handshake

### Quick Start Sequence

```
1. TCP Connect to host:3000
2. Send: {"context":"player","data":"clientname"}\r\n
3. Send: {"context":"protocol","data":{"protocol_version":4.5}}\r\n
4. Send: {"context":"init","data":null}\r\n
5. Receive: 6 init response messages
```

> ⚠️ **CRITICAL: Mandatory Message Sequence**
>
> The server enforces a **strict handshake order**:
> - **Packet 0 (first message) MUST be `player` context**
> - **Packet 1 (second message) MUST be `protocol` context**
>
> If you send any other context as your first or second message, the server will **immediately disconnect** your client. This is not optional - it is enforced at the protocol level.
>
> After the first two messages complete successfully, you may send any other commands in any order.

### Handshake Messages

**Step 1: Player Identification**
```json
{"context":"player","data":"android"}
```

**Step 2: Protocol Negotiation**
```json
{"context":"protocol","data":{"protocol_version":4.5,"no_broadcast":false}}
```

**Step 3: Request Initial State**
```json
{"context":"init","data":null}
```

### Init Response Burst

After `init`, server sends 6 messages:
1. `nowplayingtrack` - Current track metadata
2. `nowplayingrating` - Current track rating
3. `nowplayinglovestatus` - Current track love status
4. `playerstatus` - Player state (playing/paused/stopped)
5. `nowplayingcover` - Album art (Base64)
6. `nowplayinglyrics` - Track lyrics

---

## 4. Version Negotiation

### Supported Versions

| Version | Status | Features |
|---------|--------|----------|
| 4.0 | Current | Full functionality, backward compatible |
| 4.5 | Extended | Enhanced metadata, library subscriptions, ARiA |

### Request Format

```json
{
  "context": "protocol",
  "data": {
    "protocol_version": 4.5,
    "no_broadcast": false
  }
}
```

### Response Format

```json
{
  "context": "protocol",
  "data": 4
}
```

Note: Server responds with major version number (4) regardless of requested minor.

---

## 5. Connection Commands

| Context | Direction | Description |
|---------|-----------|-------------|
| `player` | C→S | Client identification |
| `protocol` | C↔S | Version negotiation |
| `init` | C→S | Request initial state |
| `ping` | C→S | Keepalive request |
| `pong` | S→C | Keepalive response |
| `verifyconnection` | C→S | Connection check |
| `pluginversion` | C→S | Get plugin version |
| `close` | C→S | Close connection |

---

## 6. Player Control Commands

### Playback Control

| Context | Description | Data |
|---------|-------------|------|
| `playerplay` | Start playback | `null` |
| `playerpause` | Pause playback | `null` |
| `playerplaypause` | Toggle play/pause | `null` |
| `playerstop` | Stop playback | `null` |
| `playernext` | Next track | `null` |
| `playerprevious` | Previous track | `null` |

### Volume Control

| Context | Description | Data |
|---------|-------------|------|
| `playervolume` | Get volume | `null` |
| `playervolume` | Set absolute | `50` (0-100) |
| `playervolume` | Increase relative | `"+10"` |
| `playervolume` | Decrease relative | `"-10"` |

### Modes

| Context | Description | Values |
|---------|-------------|--------|
| `playershuffle` | Toggle shuffle | `"off"`, `"shuffle"`, `"autodj"` |
| `playerrepeat` | Toggle repeat | `"none"`, `"all"`, `"one"` |
| `playermute` | Toggle mute | `true`, `false` |

---

## 7. Now Playing Commands

| Context | Description | Data |
|---------|-------------|------|
| `nowplayingtrack` | Get track info | `null` |
| `nowplayingcover` | Get album art (Base64) | `null` |
| `nowplayinglyrics` | Get lyrics | `null` |
| `nowplayingposition` | Get position | `null` |
| `nowplayingposition` | Seek to position | `30000` (ms) |
| `nowplayingrating` | Get rating | `null` |
| `nowplayingrating` | Set rating | `0-5` |
| `nowplayinglovestatus` | Get love status | `null` |
| `nowplayinglovestatus` | Toggle love | `"toggle"` |

### Track Response Format

```json
{
  "context": "nowplayingtrack",
  "data": {
    "artist": "Artist Name",
    "album": "Album Name",
    "title": "Track Title",
    "year": "2024",
    "path": "/path/to/file.mp3"
  }
}
```

### Position Response Format

```json
{
  "context": "nowplayingposition",
  "data": {
    "current": 45000,
    "total": 240000
  }
}
```

---

## 8. Queue Commands

| Context | Description | Data |
|---------|-------------|------|
| `nowplayinglist` | Get queue | `{"offset":0,"limit":50}` |
| `nowplayinglistplay` | Play at index | `5` |
| `nowplayinglistremove` | Remove at index | `5` |
| `nowplayinglistmove` | Move track | `{"from":3,"to":7}` |
| `nowplayinglistclear` | Clear queue | `null` |
| `nowplayingqueuenext` | Queue as next | `"/path/to/track.mp3"` |
| `nowplayingqueuelast` | Queue at end | `"/path/to/track.mp3"` |

---

## 9. Library Browse Commands

### Browse Categories

| Context | Description |
|---------|-------------|
| `browsegenres` | List genres |
| `browseartists` | List artists |
| `browsealbums` | List albums |
| `browsetracks` | List tracks |
| `browseplaylists` | List playlists |

### Request Format

```json
{
  "context": "browseartists",
  "data": {
    "offset": 0,
    "limit": 50
  }
}
```

### Search Commands

| Context | Description |
|---------|-------------|
| `librarysearchartist` | Search artists |
| `librarysearchalbum` | Search albums |
| `librarysearchtitle` | Search tracks |
| `librarysearchgenre` | Search genres |

### Search Request Format

```json
{
  "context": "librarysearchartist",
  "data": {
    "query": "Beatles",
    "offset": 0,
    "limit": 50
  }
}
```

---

## 10. Server Push Events

The server pushes events to connected clients when state changes:

| Context | Trigger |
|---------|---------|
| `playerstatus` | Player state changes |
| `nowplayingtrack` | Track changes |
| `nowplayingposition` | Position updates |
| `nowplayingcover` | Cover art changes |
| `nowplayinglyrics` | Lyrics change |
| `nowplayingrating` | Rating changes |
| `librarytagchanged` | Library tag modified (v4.5) |
| `libraryratingchanged` | Library rating modified (v4.5) |
| `libraryfiledeleted` | Track deleted (v4.5) |
| `libraryfileadded` | Track added (v4.5) |

---

## 11. Error Handling

### Error Response Format

```json
{
  "context": "error",
  "data": "Error description message"
}
```

### Common Error Scenarios

| Scenario | Behavior |
|----------|----------|
| Invalid JSON | Error response or connection continues |
| Unknown context | Silently ignored or error response |
| Missing data field | Uses default or error |
| Type mismatch | Attempts coercion or error |
| Connection timeout | Client should reconnect |

---

## 12. Implementation Checklist

### Mandatory (Must Implement)

- [ ] TCP connection to configurable host:port
- [ ] CRLF line termination for all messages
- [ ] UTF-8 encoding without BOM
- [ ] Player identification (`player` context)
- [ ] Protocol negotiation (`protocol` context)
- [ ] Init request and response handling
- [ ] Basic playback controls (play, pause, stop)
- [ ] Track navigation (next, previous)
- [ ] Now playing track info
- [ ] Graceful error handling

### Recommended (Should Implement)

- [ ] UDP discovery (multicast)
- [ ] Volume control (absolute and relative)
- [ ] Shuffle and repeat modes
- [ ] Mute control
- [ ] Cover art display
- [ ] Position display and seeking
- [ ] Rating display
- [ ] Library browsing (artists, albums, tracks)
- [ ] Pagination support
- [ ] Reconnection logic

### Optional (May Implement)

- [ ] Protocol v4.5 extended metadata
- [ ] Library subscriptions (v4.5)
- [ ] Library search
- [ ] Playlist management
- [ ] Queue management
- [ ] Lyrics display
- [ ] Love status
- [ ] ARiA initiator actions
- [ ] Output device selection
- [ ] Performance optimization

---

## Related Documentation

- [MBRCPVAL Overview](MBRCPVAL-HTML-MIRROR.md) - Validator tool reference
- [Criticality Framework](CRITICALITY-FRAMEWORK.md) - Test priorities
- [Integration Plan](INTEGRATION-PLAN.md) - Validation workflow

---

*MusicBee Remote Control Protocol - Part of the MBXRemote Project*
