# MBRCPVAL Overview

**MusicBee Remote Control Protocol Validator**

> **Documentation Index:**
> - [MBRCPVAL-SPEC.md](MBRCPVAL-SPEC.md) - Full protocol specification and test categories
> - [MBRCPVAL-IMPLEMENTATION.md](MBRCPVAL-IMPLEMENTATION.md) - Technical implementation guide
> - [MBRCPVAL-MASTERPLAN.md](MBRCPVAL-MASTERPLAN.md) - Implementation roadmap
> - [MBRCPVAL-QUICKSTART.md](MBRCPVAL-QUICKSTART.md) - Getting started guide
> - [MBRCPVAL-CHANGELOG.md](MBRCPVAL-CHANGELOG.md) - Version history

---

## What is MBRCPVAL?

MBRCPVAL (MusicBee Remote Control Protocol Validator) is a standalone validation toolkit designed to verify conformance of both **client** and **server** implementations against the MBRC Protocol specification (v4.0/v4.5). Similar to UPNP/DLNA certification tools, MBRCPVAL provides:

- **Protocol conformance testing** - Verify message formats, sequences, and responses
- **Behavioral validation** - Test state machine correctness and edge cases
- **Interoperability testing** - Ensure clients and servers work together correctly
- **Regression testing** - Automated test suites for CI/CD integration
- **Developer tooling** - Message inspector, protocol explorer, mock server/client

---

## Quick Start

```bash
# Validate your plugin against handshake tests
mbrcpval server --host localhost --port 3000 --suite handshake

# Run full test suite with HTML report
mbrcpval server --host localhost --port 3000 --suite all --report html -o report.html

# Start mock server for client development
mbrcpval mock --port 3000 --generate 500

# Interactive protocol explorer
mbrcpval repl --host localhost --port 3000

# Proxy mode for debugging client/server traffic
mbrcpval proxy --listen 3001 --target localhost:3000 --log traffic.jsonl
```

---

## Operating Modes

### Server Validation Mode

```
┌──────────┐     TCP      ┌─────────────┐
│ MBRCPVAL ├──────────────► Plugin/Server│
│ (Client) │◄─────────────┤    (SUT)    │
└──────────┘              └─────────────┘
```

MBRCPVAL acts as a protocol-aware client, sending test commands and validating server responses. Use this mode to validate your MBRC server plugin implementation.

### Client Validation Mode

```
┌─────────────┐     TCP      ┌──────────┐
│ Client App  ├──────────────► MBRCPVAL │
│   (SUT)     │◄─────────────┤ (Server) │
└─────────────┘              └──────────┘
```

MBRCPVAL acts as a mock server, validating client requests and testing client behavior. Use this mode when developing a new MBRC client application.

### Passthrough/Proxy Mode

```
┌─────────────┐     TCP      ┌──────────┐     TCP      ┌──────────┐
│ Client App  ├──────────────► MBRCPVAL ├──────────────► Plugin   │
│             │◄─────────────┤ (Proxy)  │◄─────────────┤ (Server) │
└─────────────┘              └──────────┘              └──────────┘
```

MBRCPVAL sits between client and server, logging and validating all traffic. Use this mode for debugging communication issues or analyzing protocol behavior.

---

## Test Categories

MBRCPVAL includes 150+ test cases organized into 11 categories:

| Category | Test IDs | Description |
|----------|----------|-------------|
| **Message Format** | MSG-001 to MSG-006 | JSON structure, encoding, line termination |
| **Handshake** | HSK-001 to HSK-007 | Connection sequence, protocol negotiation |
| **Player Control** | PLY-001 to PLY-014 | Play, pause, volume, shuffle, repeat |
| **Now Playing** | NP-001 to NP-009 | Track info, cover art, lyrics, position |
| **Queue Operations** | QUE-001 to QUE-007 | Add, remove, move, clear queue |
| **Library Browse** | LIB-001 to LIB-008 | Genres, artists, albums, tracks, search |
| **v4.5 Features** | V45-001 to V45-007 | Extended metadata, subscriptions, two-way sync |
| **ARiA** | ARIA-001 to ARIA-005 | Initiator actions (security-gated) |
| **Discovery** | DSC-001 to DSC-005 | UDP multicast discovery protocol |
| **Error Handling** | ERR-001 to ERR-007 | Malformed input, timeouts, invalid commands |
| **Performance** | PERF-001 to PERF-007 | Latency, throughput, stress testing |

---

## Report Formats

MBRCPVAL supports multiple output formats:

| Format | Use Case |
|--------|----------|
| **Text** | Console output, quick validation |
| **JSON** | Programmatic processing, comparison |
| **HTML** | Human-readable reports with expandable details |
| **JUnit** | CI/CD integration (GitHub Actions, Jenkins) |

---

## Technology Stack

Built on .NET 8+ for compatibility with the existing MBRC plugin codebase:

| Component | Library |
|-----------|---------|
| JSON Schema Validation | NJsonSchema |
| JSON Parsing | Newtonsoft.Json |
| CLI Framework | Spectre.Console |
| Test Case Definitions | YamlDotNet |
| Property-Based Testing | FsCheck |

---

## Related Documentation

### MBRC Protocol
- [Protocol SDK](../../tntctl/deploy/www/MBRC-Server-Plugin-Protocol.html) - Complete protocol reference
- [Plugin Documentation](../../tntctl/deploy/www/plugin.html) - Plugin installation and configuration
- [Technical Appendix](../../tntctl/deploy/www/appendix.html) - Advanced topics

### Source Code
- `mbrc-plugin-main-server/` - Server plugin reference implementation
- `tntctl/` - MBXRemote client reference implementation

---

## Implementation Status

| Phase | Status | Description |
|-------|--------|-------------|
| Phase 1 | **Complete** | Core infrastructure (schemas, validator, TCP client) |
| Phase 2 | **Complete** | Test framework (runner, suites, reporters) |
| Phase 3 | **Complete** | Mock server for client testing |
| Phase 4 | **Complete** | Advanced features (discovery, subscriptions, ARiA) |
| Phase 5 | **Complete** | Developer tools (REPL, proxy, inspector) |

See [MBRCPVAL-MASTERPLAN.md](MBRCPVAL-MASTERPLAN.md) for detailed implementation roadmap.

## Source Location

```
mbrcpval/
├── mbrcpval.csproj          # .NET 8.0 project file
├── src/
│   ├── CLI/                 # Command-line interface
│   │   ├── Program.cs       # Entry point and CLI configuration
│   │   ├── Settings/        # CommonSettings base class
│   │   └── Commands/        # ServerCommand, ValidateCommand, MockCommand, ReplCommand, ProxyCommand
│   ├── Core/                # Core infrastructure
│   │   ├── MbrcSocketClient.cs    # TCP client with NDJSON framing
│   │   ├── MessageParser.cs       # JSON message parsing
│   │   ├── SchemaValidator.cs     # NJsonSchema-based validation
│   │   └── SchemaRegistry.cs      # Schema loading and lookup
│   ├── Testing/             # Test framework
│   │   ├── TestRunner.cs          # Test execution engine
│   │   ├── YamlTestLoader.cs      # YAML test case parser
│   │   └── AssertionEvaluator.cs  # JSONPath-based assertions
│   └── Reporting/           # Report generation
│       ├── TextReporter.cs        # Console output
│       ├── JsonReporter.cs        # Machine-readable JSON
│       ├── HtmlReporter.cs        # Interactive HTML reports
│       └── JUnitReporter.cs       # CI/CD integration
├── schemas/                 # 41 JSON Schema definitions
└── tests/suites/            # 5 YAML test suites
```

---

*Version 1.5.26.3 | Updated 2026-01-04*
