# MBRCPVAL - Protocol Validator & Testing Tool

**Version:** 1.0
**Modes:** Server | Client | Proxy

> This document is a markdown mirror of the HTML documentation at `tntctl/deploy/www/mbrcpval.html`

---

## Table of Contents

1. [Overview](#1-overview)
2. [Quick Start](#2-quick-start)
3. [Operating Modes](#3-operating-modes)
4. [Test Categories](#4-test-categories)
5. [Command Reference](#5-command-reference)
6. [Report Formats](#6-report-formats)
7. [Best Practices](#7-best-practices)
8. [Installation](#8-installation)

---

## 1. Overview

### What is MBRCPVAL?

MBRCPVAL (MusicBee Remote Control Protocol Validator) is a developer tool that provides:

- **Protocol Conformance Testing** - Verify that your implementation correctly follows the MBRC protocol specification
- **Behavioral Validation** - Test that commands produce expected responses and state changes
- **Developer Tooling** - Interactive REPL, mock servers, and proxy debugging for development workflows
- **CI/CD Integration** - Generate machine-readable reports for automated testing pipelines

### Key Features

| Feature | Description |
|---------|-------------|
| **Validation** | Over 100 test cases covering message format, handshake, player control, library browsing, and v4.5 protocol features |
| **Mock Server** | Spin up a fully-functional mock MBRC server with configurable library size for client development and testing |
| **Interactive REPL** | Explore the protocol interactively, send commands, and inspect responses in real-time |
| **Proxy Mode** | Intercept and log traffic between a client and server for debugging protocol issues |

---

## 2. Quick Start

Get started with MBRCPVAL in seconds. Here are the most common usage patterns:

```bash
# Validate a server plugin
mbrcpval server --host localhost --port 3000 --suite all --report html

# Start mock server for client development
mbrcpval mock --port 3000 --generate 1000

# Interactive protocol explorer
mbrcpval repl --host localhost --port 3000

# Proxy mode for debugging
mbrcpval proxy --listen 3001 --target localhost:3000
```

> **Tip:** Use `mbrcpval --help` to see all available commands and options.

---

## 3. Operating Modes

### Server Mode (`server`)

Connects as a client to test an existing MBRC server or plugin. Runs test suites, validates protocol compliance, and generates reports.

**Use for:** Plugin development, regression testing, CI/CD validation

```
┌──────────┐     TCP      ┌─────────────┐
│ MBRCPVAL ├──────────────► Plugin/Server│
│ (Client) │◄─────────────┤    (SUT)    │
└──────────┘              └─────────────┘
```

### Client Mode (`mock`)

Starts a mock MBRC server that simulates MusicBee. Accepts client connections and responds to protocol commands with realistic data.

**Use for:** Client app development, UI testing, offline development

```
┌─────────────┐     TCP      ┌──────────┐
│ Client App  ├──────────────► MBRCPVAL │
│   (SUT)     │◄─────────────┤ (Server) │
└─────────────┘              └──────────┘
```

### Proxy Mode (`proxy`)

Acts as a man-in-the-middle between client and server, logging all traffic. Useful for debugging protocol issues in existing implementations.

**Use for:** Debugging, protocol analysis, reverse engineering

```
┌─────────────┐     TCP      ┌──────────┐     TCP      ┌──────────┐
│ Client App  ├──────────────► MBRCPVAL ├──────────────► Plugin   │
│             │◄─────────────┤ (Proxy)  │◄─────────────┤ (Server) │
└─────────────┘              └──────────┘              └──────────┘
```

---

## 4. Test Categories

MBRCPVAL organizes tests into categories, each with a unique ID prefix:

| Category | ID Range | Description | Criticality |
|----------|----------|-------------|-------------|
| **MSG** | MSG-001 to MSG-010 | Message format - JSON structure, encoding, line termination | Mandatory |
| **HSK** | HSK-001 to HSK-010 | Handshake - player identification, protocol negotiation | Mandatory/Recommended |
| **PLY** | PLY-001 to PLY-020 | Player control - play, pause, stop, seek, volume, modes | Mandatory/Recommended |
| **NP** | NP-001 to NP-015 | Now playing - track info, cover art, lyrics, position | Mandatory/Recommended |
| **QUE** | QUE-001 to QUE-010 | Queue operations - list, add, remove, move, clear | Recommended |
| **LIB** | LIB-001 to LIB-020 | Library browse - genres, artists, albums, tracks, search | Recommended/Optional |
| **V45** | V45-001 to V45-015 | v4.5 features - enhanced metadata, output devices | Optional |
| **ARIA** | ARIA-001 to ARIA-010 | Initiator actions - remote hotkeys via protocol | Optional |
| **DSC** | DSC-001 to DSC-010 | UDP discovery - multicast, response format, subnet | Optional |
| **ERR** | ERR-001 to ERR-010 | Error handling - malformed messages, invalid commands | Mandatory/Recommended |
| **PERF** | PERF-001 to PERF-010 | Performance - throughput, latency, stress testing | Optional |

### Running Specific Tests

```bash
# Run all tests
mbrcpval server --host localhost --suite all

# Run specific category
mbrcpval server --host localhost --suite PLY

# Run multiple categories
mbrcpval server --host localhost --suite PLY,NP,QUE

# Run specific test by ID
mbrcpval server --host localhost --test PLY-005

# Run by criticality
mbrcpval server --host localhost --tags mandatory
```

---

## 5. Command Reference

### `mbrcpval server` - Validate Server/Plugin

| Option | Required | Default | Description |
|--------|----------|---------|-------------|
| `--host` | Yes | - | Server hostname or IP address |
| `--port` | No | 3000 | Server TCP port |
| `--suite` | No | all | Test suite(s) to run (comma-separated or "all") |
| `--test` | No | - | Run specific test by ID |
| `--tags` | No | - | Filter by tags (mandatory, recommended, optional) |
| `--protocol` | No | 4.0 | Protocol version (4.0 or 4.5) |
| `--report` | No | text | Output format: text, json, html, junit |
| `--output` | No | stdout | Output file path |
| `--timeout` | No | 30 | Command timeout in seconds |
| `--verbose` | No | false | Show detailed test output |
| `--fail-fast` | No | false | Stop on first failure |

### `mbrcpval mock` - Start Mock Server

| Option | Required | Default | Description |
|--------|----------|---------|-------------|
| `--port` | No | 3000 | TCP port to listen on |
| `--generate` | No | 100 | Number of tracks in mock library |
| `--protocol` | No | 4.5 | Protocol version to support |
| `--discovery` | No | true | Enable UDP multicast discovery |
| `--name` | No | MBRCPVAL-MOCK | Server name for discovery |
| `--latency` | No | 0 | Artificial response delay (ms) |
| `--log` | No | - | Log all protocol traffic to file |

### `mbrcpval repl` - Interactive Mode

| Option | Required | Default | Description |
|--------|----------|---------|-------------|
| `--host` | Yes | - | Server hostname or IP address |
| `--port` | No | 3000 | Server TCP port |
| `--protocol` | No | 4.0 | Protocol version to negotiate |

**REPL Commands:**
```
.connect              Establish connection and handshake
.send player play     Send play command
.send nowplayingtrack Request now playing info
.raw {"context":"ping"} Send raw JSON message
.listen 10            Listen for events for 10 seconds
.disconnect           Close connection
.help                 Show all REPL commands
```

### `mbrcpval proxy` - Proxy Mode

| Option | Required | Default | Description |
|--------|----------|---------|-------------|
| `--listen` | No | 3001 | Port to listen for client connections |
| `--target` | Yes | - | Target server address (host:port) |
| `--output` | No | stdout | Log output file |
| `--format` | No | pretty | Log format: pretty, json, raw |
| `--filter` | No | - | Filter by context (e.g., "nowplaying*") |

### `mbrcpval validate` - Validate Single Message

| Option | Required | Default | Description |
|--------|----------|---------|-------------|
| `--message` | No | - | JSON message to validate (inline) |
| `--file` | No | - | File containing JSON message(s) |
| `--stdin` | No | false | Read message from stdin |

---

## 6. Report Formats

### Text Format (default)
Human-readable console output with colors and formatting.

### JSON Format
Machine-readable format for programmatic processing.

### HTML Format
Interactive HTML report with expandable details, suitable for sharing.

### JUnit XML Format
Compatible with CI/CD systems (Jenkins, Azure DevOps, GitHub Actions).

---

## 7. Best Practices

### For Plugin Developers

1. **Run full validation before release:** Use `--suite all` to catch any protocol regressions
2. **Test both protocol versions:** Run tests with `--protocol 4.0` and `--protocol 4.5`
3. **Integrate into CI/CD:** Use JUnit output for automated testing
4. **Focus on error handling:** The ERR test suite specifically validates edge cases
5. **Validate discovery:** Ensure UDP discovery works with `--suite DSC`

### For Client Developers

1. **Use mock server during development:** `mbrcpval mock --generate 1000`
2. **Test edge cases:** Use `--latency` to simulate slow connections
3. **Explore with REPL:** The interactive mode helps understand protocol behavior
4. **Validate your messages:** Use `mbrcpval validate` to check message format
5. **Test reconnection:** Kill and restart mock server to test reconnection logic

### For QA/Testing

1. **Use proxy mode for debugging:** Intercept traffic between real client and server
2. **Generate comprehensive reports:** HTML reports are ideal for sharing
3. **Run performance tests:** The PERF suite measures response times
4. **Test under load:** Use multiple mock clients with the mock server
5. **Compare versions:** Run tests against multiple plugin versions for regression testing

---

## 8. Installation

### System Requirements

- **Runtime:** .NET 8.0 or later
- **Operating System:** Windows 10/11, Linux, macOS
- **Memory:** 128 MB minimum
- **Network:** TCP/UDP access to target server

### Installation Options

**Option 1: Build from Source**
```bash
cd mbrcpval
dotnet build -c Release
```

**Option 2: .NET Tool (Global)**
```bash
dotnet tool install -g mbrcpval
```

---

## Related Documentation

- [MBRC Protocol SDK](PROTOCOL-SDK-MIRROR.md) - Complete protocol reference
- [Criticality Framework](CRITICALITY-FRAMEWORK.md) - Test criticality levels
- [Integration Plan](INTEGRATION-PLAN.md) - Step-by-step integration guide

---

*MBRCPVAL Protocol Validator - Part of the MBXRemote Project*
