# MBRCPVAL Known Issues

**Version:** 1.0.0
**Date:** 2026-01-01
**Status:** Active

---

## Issue Severity

| Severity | Description |
|----------|-------------|
| Critical | Prevents tool operation |
| High | Significant impact on functionality |
| Medium | Workaround available |
| Low | Minor inconvenience |

---

## Open Issues

### BUG-001: YAML Test Loader Missing Criticality Tag Support

**Severity:** Medium
**Status:** Open
**Component:** Testing/YamlTestLoader.cs

**Description:**
The YAML test loader parses the `tags` field but the criticality concept is not formally integrated into filtering logic. Need to add:
- Filter by criticality level (mandatory, recommended, optional)
- Report grouping by criticality
- Summary statistics by level

**Workaround:**
Use `--tags mandatory` to filter by criticality tag manually.

**Fix Required:**
- Add `Criticality` enum to TestCase model
- Parse criticality from tags in YamlTestLoader
- Add `--criticality` CLI filter option
- Update reporters to show criticality breakdown

---

### BUG-002: TestRunner Parallel Execution Shared State

**Severity:** High
**Status:** Fixed (v1.0.1)
**Component:** Testing/TestRunner.cs

**Description:**
Parallel test execution with shared MbrcSocketClient caused race conditions. The MBRC protocol is stateful and cannot share a single connection.

**Resolution:**
- Fixed: Each parallel test now uses its own client instance
- Added warning in MaxParallelism property documentation
- Added connection lock for state management

---

### BUG-003: SchemaValidator Cache Race Condition

**Severity:** Medium
**Status:** Fixed (v1.0.1)
**Component:** Core/SchemaValidator.cs

**Description:**
Schema cache dictionary was accessed without proper locking, causing potential race conditions under concurrent validation.

**Resolution:**
- Added lock around cache access
- Fixed sync-over-async deadlock in ValidateJson

---

### BUG-004: ProxyCommand Log Writer Not Thread-Safe

**Severity:** Medium
**Status:** Fixed (v1.0.1)
**Component:** CLI/Commands/ProxyCommand.cs

**Description:**
Multiple proxy sessions writing to same log file could interleave output.

**Resolution:**
- Added SemaphoreSlim for log writer access
- Used Interlocked for message counting

---

### BUG-005: Missing Test Suite Priority Values

**Severity:** Low
**Status:** Open
**Component:** tests/suites/*.yaml

**Description:**
Existing YAML test files don't specify `priority` values. All tests default to priority 100, making ordering arbitrary.

**Fix Required:**
- Update all YAML files with appropriate priority values
- Priority 1-30 for mandatory, 31-70 for recommended, 71-100 for optional

---

### BUG-006: expect_multiple Step Type Not Fully Implemented

**Severity:** Medium
**Status:** Open
**Component:** Testing/TestRunner.cs

**Description:**
The `expect_multiple` step type in YAML (used in handshake tests for init burst) may not correctly validate all expected contexts. Need verification.

**Workaround:**
Use individual expect steps if issues occur.

**Fix Required:**
- Audit expect_multiple implementation
- Add unit tests for this step type
- Verify timeout handling for multiple messages

---

### BUG-007: Assertion Evaluator JSONPath Edge Cases

**Severity:** Low
**Status:** Open
**Component:** Testing/AssertionEvaluator.cs

**Description:**
Some JSONPath expressions may not work as expected:
- `$.data.length` for array length
- Negative array indices `$[-1]`
- Wildcard selections `$[*]`

**Workaround:**
Use explicit paths and type assertions.

**Fix Required:**
- Document supported JSONPath subset
- Add more comprehensive JSONPath tests
- Consider switching to Json.NET SelectToken for full support

---

### BUG-008: Mock Server Discovery Broadcast Not Implemented

**Severity:** Low
**Status:** Open
**Component:** CLI/Commands/MockCommand.cs

**Description:**
The `--discovery` flag is documented but UDP discovery broadcast is not fully implemented in the mock server.

**Fix Required:**
- Implement UdpDiscoveryServer class
- Add multicast group join/leave
- Respond to discovery requests

---

### BUG-009: HTML Reporter Missing Collapsible Sections

**Severity:** Low
**Status:** Open
**Component:** Reporting/HtmlReporter.cs

**Description:**
Generated HTML reports don't have collapsible test details as documented. All content is expanded.

**Fix Required:**
- Add JavaScript for expand/collapse
- Group tests by suite/category
- Add summary dashboard

---

### BUG-010: ReplCommand History Persistence

**Severity:** Low
**Status:** Open
**Component:** CLI/Commands/ReplCommand.cs

**Description:**
REPL command history is not persisted between sessions. The `--history` flag is documented but not functional.

**Fix Required:**
- Implement history file read/write
- Use default path ~/.mbrcpval_history
- Add history navigation

---

## Recently Fixed

| Issue | Severity | Version Fixed | Description |
|-------|----------|---------------|-------------|
| BUG-002 | High | 1.0.1 | TestRunner parallel execution |
| BUG-003 | Medium | 1.0.1 | SchemaValidator cache race |
| BUG-004 | Medium | 1.0.1 | ProxyCommand log thread safety |
| Event handler exceptions | Medium | 1.0.1 | Added SafeInvokeEvent wrapper |
| Disposed flag visibility | Medium | 1.0.1 | Added volatile modifier |
| CTS not disposed | Low | 1.0.1 | Fixed MockCommand cleanup |

---

## Won't Fix

| Issue | Reason |
|-------|--------|
| Windows-only line endings | Protocol spec requires CRLF |
| No WebSocket support | Protocol uses raw TCP |

---

## Feature Requests (Tracked Separately)

See [BACKLOG.md](BACKLOG.md) for feature requests and missing functionality.

---

*Last Updated: 2026-01-01*
