# MBRCPVAL Validator Integration Plan

**Version:** 1.0.0
**Date:** 2026-01-01
**Status:** Active

---

## Overview

This document provides a step-by-step integration plan for validators (QA engineers, plugin developers, and client developers) to integrate MBRCPVAL into their workflow and understand how to achieve protocol compliance.

---

## Integration Steps

### Step 1: Environment Setup

1. **Install Prerequisites**
   ```bash
   # Verify .NET 8.0+ is installed
   dotnet --version
   ```

2. **Obtain MBRCPVAL**
   ```bash
   # Option A: Build from source
   cd mbrc-plugin-main-server/mbrcpval
   dotnet build -c Release

   # Option B: Use published executable
   # Download from releases
   ```

3. **Verify Installation**
   ```bash
   mbrcpval --version
   mbrcpval --help
   ```

---

### Step 2: Understand Test Criticality

Before running tests, understand the three criticality levels:

| Level | Tag | Description | Compliance |
|-------|-----|-------------|------------|
| **MANDATORY** | `mandatory` | Must pass for basic functionality | Required |
| **RECOMMENDED** | `recommended` | Should pass for good UX | Expected |
| **OPTIONAL** | `optional` | May pass for full features | Nice to have |

**Priority Ranges:**
- Mandatory: 1-30
- Recommended: 31-70
- Optional: 71-100

---

### Step 3: Initial Validation (Smoke Test)

Run mandatory tests first to verify basic connectivity:

```bash
# Connect to your server and run mandatory tests only
mbrcpval server --host localhost --port 3000 --tags mandatory

# Expected output:
# MBRCPVAL Protocol Validation
# ============================
# Target: localhost:3000
# Tests: 15 (mandatory only)
#
# [PASS] HSK-001 Valid Handshake Sequence
# [PASS] HSK-002 Protocol v4.0 Negotiation
# [PASS] PLY-001 Play Command
# ...
#
# RESULT: 15/15 mandatory tests passed
```

**If any mandatory tests fail:** Stop and fix these before proceeding.

---

### Step 4: Standard Validation

Once mandatory tests pass, run the full recommended suite:

```bash
# Run mandatory + recommended tests
mbrcpval server --host localhost --port 3000 --tags mandatory,recommended --report html --output standard-report.html
```

**Target:** 100% mandatory, 90%+ recommended

---

### Step 5: Full Validation

For reference implementations or full compliance certification:

```bash
# Run all tests including optional
mbrcpval server --host localhost --port 3000 --suite all --report html --output full-report.html
```

**Target:** 100% mandatory, 100% recommended, 80%+ optional

---

### Step 6: Integrate with CI/CD

Add validation to your build pipeline:

```yaml
# GitHub Actions Example
- name: MBRC Protocol Validation
  run: |
    mbrcpval server \
      --host ${{ secrets.TEST_HOST }} \
      --port 3000 \
      --tags mandatory,recommended \
      --report junit \
      --output test-results.xml \
      --fail-fast

- name: Upload Test Results
  uses: actions/upload-artifact@v4
  with:
    name: protocol-test-results
    path: test-results.xml
```

**Recommended CI Settings:**
- Run on every PR
- Block merge on mandatory failures
- Warn on recommended failures
- Info on optional failures

---

## Test Suite Reference

### Available Test Suites

| Suite | File | Tests | Description |
|-------|------|-------|-------------|
| Handshake | `handshake.yaml` | 8 | Connection & protocol negotiation |
| Player Control | `player-control.yaml` | 14 | Play, pause, volume, modes |
| Now Playing | `now-playing.yaml` | 10 | Track info, cover, lyrics, rating |
| Library | `library.yaml` | 10 | Browse, search, pagination |
| Errors | `errors.yaml` | 10 | Error handling, robustness |

### Run Specific Suites

```bash
# Run single suite
mbrcpval server --host localhost --suite handshake

# Run multiple suites
mbrcpval server --host localhost --suite handshake,player-control

# Run specific test by ID
mbrcpval server --host localhost --test HSK-001
```

---

## Criticality Summary by Suite

### Handshake (8 tests)
- **Mandatory:** HSK-001, HSK-002, HSK-004, HSK-006
- **Recommended:** HSK-003, HSK-005, HSK-007
- **Optional:** HSK-008

### Player Control (14 tests)
- **Mandatory:** PLY-001 to PLY-006
- **Recommended:** PLY-007 to PLY-009, PLY-012 to PLY-014
- **Optional:** PLY-010, PLY-011

### Now Playing (10 tests)
- **Mandatory:** NP-001, NP-004
- **Recommended:** NP-002, NP-005, NP-006
- **Optional:** NP-003, NP-007 to NP-010

### Library (10 tests)
- **Mandatory:** None
- **Recommended:** LIB-001 to LIB-004, LIB-006
- **Optional:** LIB-005, LIB-007 to LIB-010

### Errors (10 tests)
- **Mandatory:** ERR-001, ERR-002
- **Recommended:** ERR-003 to ERR-006
- **Optional:** ERR-007 to ERR-010

---

## Compliance Certification

### Level 1: Bronze Certification

**Requirements:**
- 100% mandatory tests pass
- Basic protocol functionality verified

**Validation Command:**
```bash
mbrcpval server --host localhost --tags mandatory --report json --output bronze.json
```

**Badge:** 🥉 MBRC Bronze Certified

---

### Level 2: Silver Certification

**Requirements:**
- 100% mandatory tests pass
- 90%+ recommended tests pass

**Validation Command:**
```bash
mbrcpval server --host localhost --tags mandatory,recommended --report json --output silver.json
```

**Badge:** 🥈 MBRC Silver Certified

---

### Level 3: Gold Certification

**Requirements:**
- 100% mandatory tests pass
- 100% recommended tests pass
- 80%+ optional tests pass

**Validation Command:**
```bash
mbrcpval server --host localhost --suite all --report json --output gold.json
```

**Badge:** 🥇 MBRC Gold Certified

---

### Level 4: Platinum Certification

**Requirements:**
- 100% all tests pass (mandatory, recommended, optional)
- Reference implementation quality

**Validation Command:**
```bash
mbrcpval server --host localhost --suite all --report json --output platinum.json
```

**Badge:** 💎 MBRC Platinum Certified

---

## Troubleshooting

### Common Issues

1. **Connection Refused**
   ```
   Error: Connection refused at localhost:3000
   ```
   - Verify MusicBee is running
   - Verify plugin is enabled
   - Check firewall settings
   - Verify port in plugin settings

2. **Handshake Timeout**
   ```
   [FAIL] HSK-001: Timeout waiting for player response
   ```
   - Check if plugin is responding
   - Increase timeout: `--timeout 60`
   - Enable verbose: `--verbose`

3. **Protocol Version Mismatch**
   ```
   [FAIL] HSK-003: Expected protocol 4.5, got 4
   ```
   - Update plugin to latest version
   - Or run with `--protocol 4.0`

4. **Library Tests Fail**
   ```
   [FAIL] LIB-001: Empty array returned
   ```
   - Ensure MusicBee library has tracks
   - Check library scan status

---

## Report Interpretation

### Understanding Results

```
MBRCPVAL Protocol Validation Report
====================================
Target: localhost:3000
Protocol: v4.5
Duration: 45.2s

CRITICALITY BREAKDOWN
---------------------
MANDATORY:   15/15 (100%) ✅  <- Must be 100%
RECOMMENDED: 27/30 (90%)  ⚠️  <- Should be 90%+
OPTIONAL:    8/12  (67%)  ℹ️  <- Nice to have

FAILED TESTS
------------
[FAIL] PLY-008: Volume Relative Increase
       Expected: 60
       Actual: 50
       Note: Relative volume adjustment not working

[FAIL] NP-003: Get Lyrics
       Expected: lyrics string
       Actual: empty string
       Note: Track may not have lyrics

[FAIL] LIB-007: Search Artist
       Timeout: No response in 5000ms
       Note: Search may be slow for large libraries

COMPLIANCE: SILVER LEVEL 🥈
```

### Reading Test Output

- ✅ **PASS** - Test completed successfully
- ❌ **FAIL** - Assertion failed, see details
- ⏭️ **SKIP** - Test skipped (prerequisites not met)
- ⚠️ **WARN** - Test passed with warnings
- 💥 **ERROR** - Unexpected exception occurred

---

## Related Documentation

- [Criticality Framework](CRITICALITY-FRAMEWORK.md) - Detailed criticality definitions
- [Backlog](BACKLOG.md) - Missing tests and features
- [Issues](ISSUES.md) - Known bugs and limitations
- [MBRCPVAL Overview](../MBRCPVAL-Overview.md) - Tool overview
- [MBRCPVAL Spec](../MBRCPVAL-SPEC.md) - Full specification

---

## Support

For issues or questions:
1. Check [ISSUES.md](ISSUES.md) for known problems
2. Review [BACKLOG.md](BACKLOG.md) for planned features
3. File issues at GitHub repository

---

*Last Updated: 2026-01-01*
