# MBRCPVAL Test Criticality Framework

**Version:** 1.0.0
**Date:** 2026-01-01
**Status:** ACTIVE

---

## Overview

This document defines the test criticality framework for MBRCPVAL (MusicBee Remote Control Protocol Validator). Tests are categorized into three compliance levels that help implementers prioritize validation efforts and understand which behaviors are essential vs. optional.

---

## Compliance Levels

### Level 1: MANDATORY (Tag: `mandatory`)

**Definition:** Tests that MUST pass for basic protocol compliance. Failure indicates a broken implementation that cannot function correctly.

**Criteria:**
- Connection cannot be established without passing
- Core functionality is impossible without compliance
- Protocol violation that breaks interoperability
- Security-critical behaviors

**Priority Range:** 1-30

**Visual Indicator:** 🔴 Red / Critical

---

### Level 2: RECOMMENDED (Tag: `recommended`)

**Definition:** Tests that SHOULD pass for a good user experience. Failure indicates degraded functionality but basic operation is possible.

**Criteria:**
- Feature works but with limitations
- Alternative workarounds exist
- User experience is degraded but usable
- Non-critical data may be missing

**Priority Range:** 31-70

**Visual Indicator:** 🟡 Yellow / Warning

---

### Level 3: OPTIONAL (Tag: `optional`)

**Definition:** Tests that MAY pass for full feature parity. Failure indicates missing advanced features that many users won't need.

**Criteria:**
- Advanced features not commonly used
- Performance optimizations
- Extended v4.5 features
- Developer/debugging aids
- Edge case handling

**Priority Range:** 71-100

**Visual Indicator:** 🟢 Green / Info

---

## Test Category Classification

### Handshake Tests (HSK-xxx)

| Test ID | Name | Level | Rationale |
|---------|------|-------|-----------|
| HSK-001 | Valid Handshake Sequence | **MANDATORY** | Cannot use protocol without handshake |
| HSK-002 | Protocol v4.0 Negotiation | **MANDATORY** | Version negotiation is required |
| HSK-003 | Protocol v4.5 Negotiation | **RECOMMENDED** | v4.5 optional but expected |
| HSK-004 | Player Identification | **MANDATORY** | Must identify client |
| HSK-005 | No Broadcast Mode | **RECOMMENDED** | Optional optimization |
| HSK-006 | Init After Protocol | **MANDATORY** | Required to get initial state |
| HSK-007 | Reconnection Handshake | **RECOMMENDED** | Important for reliability |
| HSK-008 | Empty Player Name | **OPTIONAL** | Edge case handling |

### Player Control Tests (PLY-xxx)

| Test ID | Name | Level | Rationale |
|---------|------|-------|-----------|
| PLY-001 | Play Command | **MANDATORY** | Core functionality |
| PLY-002 | Pause Command | **MANDATORY** | Core functionality |
| PLY-003 | Stop Command | **MANDATORY** | Core functionality |
| PLY-004 | Play/Pause Toggle | **MANDATORY** | Most common control |
| PLY-005 | Next Track | **MANDATORY** | Core navigation |
| PLY-006 | Previous Track | **MANDATORY** | Core navigation |
| PLY-007 | Volume Set Absolute | **RECOMMENDED** | Common feature |
| PLY-008 | Volume Relative Increase | **RECOMMENDED** | UX convenience |
| PLY-009 | Volume Relative Decrease | **RECOMMENDED** | UX convenience |
| PLY-010 | Volume Boundary Min | **OPTIONAL** | Edge case |
| PLY-011 | Volume Boundary Max | **OPTIONAL** | Edge case |
| PLY-012 | Mute Toggle | **RECOMMENDED** | Common feature |
| PLY-013 | Shuffle Modes | **RECOMMENDED** | Common feature |
| PLY-014 | Repeat Modes | **RECOMMENDED** | Common feature |

### Now Playing Tests (NP-xxx)

| Test ID | Name | Level | Rationale |
|---------|------|-------|-----------|
| NP-001 | Get Current Track | **MANDATORY** | Essential display info |
| NP-002 | Get Cover Art | **RECOMMENDED** | Visual appeal |
| NP-003 | Get Lyrics | **OPTIONAL** | Not always available |
| NP-004 | Get Position | **MANDATORY** | Progress display |
| NP-005 | Seek to Position | **RECOMMENDED** | Common feature |
| NP-006 | Get Rating | **RECOMMENDED** | Metadata display |
| NP-007 | Set Rating | **OPTIONAL** | Write operation |
| NP-008 | Get Details Extended | **OPTIONAL** | Extended metadata |
| NP-009 | Get Love Status | **OPTIONAL** | Extended metadata |
| NP-010 | Toggle Love Status | **OPTIONAL** | Write operation |

### Library Tests (LIB-xxx)

| Test ID | Name | Level | Rationale |
|---------|------|-------|-----------|
| LIB-001 | Browse Genres | **RECOMMENDED** | Library browsing |
| LIB-002 | Browse Artists | **RECOMMENDED** | Library browsing |
| LIB-003 | Browse Albums | **RECOMMENDED** | Library browsing |
| LIB-004 | Browse Tracks v4.0 | **RECOMMENDED** | Library browsing |
| LIB-005 | Browse Tracks v4.5 Extended | **OPTIONAL** | v4.5 feature |
| LIB-006 | Pagination Test | **RECOMMENDED** | Large library support |
| LIB-007 | Search Artist | **OPTIONAL** | Search feature |
| LIB-008 | Search Album | **OPTIONAL** | Search feature |
| LIB-009 | Search Title | **OPTIONAL** | Search feature |
| LIB-010 | Browse Playlists | **OPTIONAL** | Advanced feature |

### Error Handling Tests (ERR-xxx)

| Test ID | Name | Level | Rationale |
|---------|------|-------|-----------|
| ERR-001 | Invalid JSON | **MANDATORY** | Must handle gracefully |
| ERR-002 | Unknown Context | **MANDATORY** | Must not crash |
| ERR-003 | Missing Required Field | **RECOMMENDED** | Robustness |
| ERR-004 | Wrong Data Type | **RECOMMENDED** | Robustness |
| ERR-005 | Empty Context | **RECOMMENDED** | Edge case |
| ERR-006 | Null Context | **RECOMMENDED** | Edge case |
| ERR-007 | Rating Out of Range High | **OPTIONAL** | Boundary checking |
| ERR-008 | Rating Out of Range Low | **OPTIONAL** | Boundary checking |
| ERR-009 | Invalid Seek Position | **OPTIONAL** | Boundary checking |
| ERR-010 | Oversized Request | **OPTIONAL** | Stress handling |

---

## Compliance Profiles

### Minimal Compliance (Entry Level)

Pass all **MANDATORY** tests only.

**Use Case:** Quick proof-of-concept, testing environments

**Expected Pass Rate:** 100% mandatory tests

### Standard Compliance (Production Ready)

Pass all **MANDATORY** and **RECOMMENDED** tests.

**Use Case:** Production applications, public releases

**Expected Pass Rate:** 100% mandatory, 90%+ recommended

### Full Compliance (Reference Implementation)

Pass all **MANDATORY**, **RECOMMENDED**, and **OPTIONAL** tests.

**Use Case:** Reference implementations, protocol documentation

**Expected Pass Rate:** 100% mandatory, 100% recommended, 95%+ optional

---

## Using Criticality in MBRCPVAL

### Running Tests by Criticality

```bash
# Run only mandatory tests (minimum compliance check)
mbrcpval server --host localhost --tags mandatory

# Run mandatory + recommended (production readiness)
mbrcpval server --host localhost --tags mandatory,recommended

# Run all tests
mbrcpval server --host localhost --suite all

# Exclude optional tests
mbrcpval server --host localhost --exclude-tags optional
```

### Report Interpretation

Reports show criticality breakdown:

```
MBRCPVAL Protocol Validation Report
====================================
Target: localhost:3000
Protocol: v4.5

CRITICALITY SUMMARY
-------------------
MANDATORY:   25/25 (100%) ✅
RECOMMENDED: 38/42 (90%)  ⚠️
OPTIONAL:    12/33 (36%)  ℹ️

Overall: STANDARD COMPLIANCE ACHIEVED
```

---

## YAML Test File Format

Tests use the `tags` field for criticality:

```yaml
tests:
  - id: HSK-001
    name: Valid Handshake Sequence
    description: Verify complete handshake with player, protocol, init
    priority: 1
    tags:
      - mandatory
      - smoke
      - handshake
    steps:
      # ... test steps
```

---

## Certification Levels

Based on test results, implementations can claim:

| Level | Badge | Requirements |
|-------|-------|--------------|
| Bronze | 🥉 | 100% mandatory |
| Silver | 🥈 | 100% mandatory + 90% recommended |
| Gold | 🥇 | 100% mandatory + 100% recommended + 80% optional |
| Platinum | 💎 | 100% all tests |

---

## Revision History

| Version | Date | Changes |
|---------|------|---------|
| 1.0.0 | 2026-01-01 | Initial criticality framework |

---

*This framework ensures consistent quality assessment across all MBRC protocol implementations.*
