# MBRCPVAL Implementation Backlog

**Version:** 1.0.0
**Date:** 2026-01-01
**Status:** Active

---

## Priority Legend

| Priority | Description |
|----------|-------------|
| P0 | Critical - Blocks core functionality |
| P1 | High - Significant gap in coverage |
| P2 | Medium - Important but not blocking |
| P3 | Low - Nice to have |

---

## Missing Test Suites

### SUITE-001: Queue Operations (P1)

**Status:** NOT IMPLEMENTED

**Description:** Queue/playlist management tests are specified in SPEC but not implemented as YAML suite.

**Required Tests:**
- [ ] QUE-001: Get Now Playing List
- [ ] QUE-002: Play Track at Index
- [ ] QUE-003: Remove Track from Queue
- [ ] QUE-004: Move Track in Queue
- [ ] QUE-005: Clear Queue
- [ ] QUE-006: Queue Next
- [ ] QUE-007: Queue Last

**File to Create:** `tests/suites/queue.yaml`

---

### SUITE-002: Discovery Protocol (P2)

**Status:** NOT IMPLEMENTED

**Description:** UDP discovery protocol tests are specified but not implemented.

**Required Tests:**
- [ ] DSC-001: Discovery Request Format
- [ ] DSC-002: Discovery Response Format
- [ ] DSC-003: Subnet Matching
- [ ] DSC-004: Missing Address Field
- [ ] DSC-005: Multiple Servers

**File to Create:** `tests/suites/discovery.yaml`

---

### SUITE-003: v4.5 Extended Features (P2)

**Status:** NOT IMPLEMENTED

**Description:** Protocol v4.5 specific features need dedicated test suite.

**Required Tests:**
- [ ] V45-001: Extended Metadata in browsetracks
- [ ] V45-002: librarysetrating
- [ ] V45-003: librarysetlove
- [ ] V45-004: librarysubscribe
- [ ] V45-005: librarytagchanged event
- [ ] V45-006: libraryratingchanged event
- [ ] V45-007: libraryunsubscribe

**File to Create:** `tests/suites/v45-features.yaml`

---

### SUITE-004: ARiA Tests (P3)

**Status:** NOT IMPLEMENTED

**Description:** ARiA (Initiator Actions) feature tests.

**Required Tests:**
- [ ] ARIA-001: playerinitiatoraction (enabled)
- [ ] ARIA-002: playerinitiatoraction (disabled)
- [ ] ARIA-003: pluginstoragepath (enabled)
- [ ] ARIA-004: pluginstoragepath (disabled)
- [ ] ARIA-005: configureariahotkeys check

**File to Create:** `tests/suites/aria.yaml`

---

### SUITE-005: Performance Tests (P3)

**Status:** NOT IMPLEMENTED

**Description:** Performance and stress testing suite.

**Required Tests:**
- [ ] PERF-001: Handshake Latency
- [ ] PERF-002: Command Response Time
- [ ] PERF-003: Large Library Browse
- [ ] PERF-004: Concurrent Connections
- [ ] PERF-005: Rapid Fire Commands
- [ ] PERF-006: Cover Art Response Time
- [ ] PERF-007: Memory Stability

**File to Create:** `tests/suites/performance.yaml`

---

## Missing Tests in Existing Suites

### HANDSHAKE Suite Gaps

| Test ID | Name | Priority | Status |
|---------|------|----------|--------|
| HSK-009 | Invalid Protocol Version | P2 | Missing |
| HSK-010 | Concurrent Connections | P3 | Missing |

### PLAYER-CONTROL Suite Gaps

| Test ID | Name | Priority | Status |
|---------|------|----------|--------|
| PLY-015 | Next Album | P2 | Missing |
| PLY-016 | Previous Album | P2 | Missing |
| PLY-017 | AutoDJ Mode | P3 | Missing |
| PLY-018 | Output Device Switch | P2 | Missing |
| PLY-019 | Scrobble Toggle | P3 | Missing |
| PLY-020 | Get Player Status | P2 | Missing |

### NOW-PLAYING Suite Gaps

| Test ID | Name | Priority | Status |
|---------|------|----------|--------|
| NP-011 | Last.fm Rating | P3 | Missing |
| NP-012 | Tag Change | P3 | Missing |
| NP-013 | Cover Art Caching | P3 | Missing |

### LIBRARY Suite Gaps

| Test ID | Name | Priority | Status |
|---------|------|----------|--------|
| LIB-011 | Artist Albums | P2 | Missing |
| LIB-012 | Album Tracks | P2 | Missing |
| LIB-013 | Genre Artists | P2 | Missing |
| LIB-014 | Queue Genre | P2 | Missing |
| LIB-015 | Queue Artist | P2 | Missing |
| LIB-016 | Queue Album | P2 | Missing |
| LIB-017 | Queue Track | P2 | Missing |
| LIB-018 | Play All | P2 | Missing |
| LIB-019 | Album Cover | P2 | Missing |
| LIB-020 | Search Genre | P3 | Missing |

### ERROR Suite Gaps

| Test ID | Name | Priority | Status |
|---------|------|----------|--------|
| ERR-011 | Connection Timeout Recovery | P2 | Missing |
| ERR-012 | Ping/Pong Failure | P2 | Missing |
| ERR-013 | Partial Message Handling | P3 | Missing |

---

## Schema Gaps

### Missing Request Schemas

| Schema | Priority | Status |
|--------|----------|--------|
| nowplayinglistplay.schema.json | P1 | Missing |
| nowplayinglistremove.schema.json | P1 | Missing |
| nowplayinglistmove.schema.json | P1 | Missing |
| nowplayinglistclear.schema.json | P1 | Missing |
| nowplayingqueuenext.schema.json | P1 | Missing |
| nowplayingqueuelast.schema.json | P1 | Missing |
| librarysubscribe.schema.json | P2 | Missing |
| libraryunsubscribe.schema.json | P2 | Missing |
| libraryartistalbums.schema.json | P2 | Missing |
| libraryalbumtracks.schema.json | P2 | Missing |
| librarygenreartists.schema.json | P2 | Missing |
| libraryqueuegenre.schema.json | P2 | Missing |
| libraryqueueartist.schema.json | P2 | Missing |
| libraryqueuealbum.schema.json | P2 | Missing |
| libraryqueuetrack.schema.json | P2 | Missing |
| libraryplayall.schema.json | P2 | Missing |
| libraryalbumcover.schema.json | P2 | Missing |

### Missing Response Schemas

| Schema | Priority | Status |
|--------|----------|--------|
| nowplayinglist-response.schema.json | P1 | Missing |
| librarysubscribe-response.schema.json | P2 | Missing |

### Missing Event Schemas

| Schema | Priority | Status |
|--------|----------|--------|
| playlistcreated.schema.json | P3 | Missing |
| playlistupdated.schema.json | P3 | Missing |
| playlistdeleted.schema.json | P3 | Missing |

---

## Documentation Gaps

| Document | Priority | Status |
|----------|----------|--------|
| Protocol SDK (MD mirror) | P2 | Not Created |
| Validator Guide (MD mirror) | P2 | Not Created |
| Integration Guide | P2 | Not Created |
| API Reference | P3 | Not Created |

---

## Feature Requests

### FR-001: Schema Auto-Generation (P3)

Generate JSON Schemas from protocol analysis or existing code.

### FR-002: Interactive Test Builder (P3)

GUI or wizard for creating custom test cases.

### FR-003: Diff Reports (P3)

Compare results between two test runs.

### FR-004: Coverage Analysis (P2)

Show which protocol contexts are covered by tests.

---

## Summary Statistics

| Category | Implemented | Missing | Completion |
|----------|-------------|---------|------------|
| Test Suites | 5 | 5 | 50% |
| Individual Tests | 49 | 51+ | ~49% |
| Request Schemas | 22 | 17 | 56% |
| Response Schemas | 12 | 2 | 86% |
| Event Schemas | 7 | 3 | 70% |

---

## Next Actions

1. **Immediate (P0-P1):**
   - Create queue.yaml test suite
   - Add missing queue operation schemas
   - Add criticality tags to existing tests

2. **Short-term (P2):**
   - Create discovery.yaml test suite
   - Create v45-features.yaml test suite
   - Fill library test gaps
   - Mirror HTML docs as MD

3. **Long-term (P3):**
   - Create aria.yaml test suite
   - Create performance.yaml test suite
   - Implement coverage analysis
   - Build interactive test builder

---

*Last Updated: 2026-01-01*
