using MusicBeePlugin.AndroidRemote.Networking;
using NUnit.Framework;

namespace MusicBeePlugin.Tests
{
    /// <summary>
    /// Tests for protocol constants to ensure they don't change unexpectedly.
    /// Breaking changes to these values would break client compatibility.
    /// </summary>
    [TestFixture]
    public class ConstantsTests
    {
        #region Protocol Version Tests

        [Test]
        public void ProtocolVersion_IsExpectedValue()
        {
            Assert.AreEqual(4.0, Constants.ProtocolVersion);
        }

        [Test]
        public void ProtocolVersionWithAria_IsGreaterThanBase()
        {
            Assert.Greater(Constants.ProtocolVersionWithAria, Constants.ProtocolVersion);
        }

        [Test]
        public void ProtocolVersionWithAria_IsExpectedValue()
        {
            Assert.AreEqual(4.5, Constants.ProtocolVersionWithAria);
        }

        #endregion

        #region Socket Message Context Tests

        [Test]
        public void Player_ContextIsLowercase()
        {
            Assert.AreEqual("player", Constants.Player);
        }

        [Test]
        public void PluginVersion_ContextIsLowercase()
        {
            Assert.AreEqual("pluginversion", Constants.PluginVersion);
        }

        [Test]
        public void PluginInstanceId_ContextIsLowercase()
        {
            Assert.AreEqual("plugininstanceid", Constants.PluginInstanceId);
        }

        [Test]
        public void NotAllowed_ContextIsLowercase()
        {
            Assert.AreEqual("notallowed", Constants.NotAllowed);
        }

        [Test]
        public void Protocol_ContextIsLowercase()
        {
            Assert.AreEqual("protocol", Constants.Protocol);
        }

        #endregion

        #region Player Control Constants

        [Test]
        public void PlayerPlay_IsCorrect()
        {
            Assert.AreEqual("playerplay", Constants.PlayerPlay);
        }

        [Test]
        public void PlayerPause_IsCorrect()
        {
            Assert.AreEqual("playerpause", Constants.PlayerPause);
        }

        [Test]
        public void PlayerStop_IsCorrect()
        {
            Assert.AreEqual("playerstop", Constants.PlayerStop);
        }

        [Test]
        public void PlayerNext_IsCorrect()
        {
            Assert.AreEqual("playernext", Constants.PlayerNext);
        }

        [Test]
        public void PlayerPrevious_IsCorrect()
        {
            Assert.AreEqual("playerprevious", Constants.PlayerPrevious);
        }

        #endregion

        #region Volume and Playback Constants

        [Test]
        public void PlayerVolume_IsCorrect()
        {
            Assert.AreEqual("playervolume", Constants.PlayerVolume);
        }

        [Test]
        public void PlayerShuffle_IsCorrect()
        {
            Assert.AreEqual("playershuffle", Constants.PlayerShuffle);
        }

        [Test]
        public void PlayerRepeat_IsCorrect()
        {
            Assert.AreEqual("playerrepeat", Constants.PlayerRepeat);
        }

        [Test]
        public void PlayerMute_IsCorrect()
        {
            Assert.AreEqual("playermute", Constants.PlayerMute);
        }

        #endregion

        #region Track Info Constants

        [Test]
        public void NowPlayingTrack_IsCorrect()
        {
            Assert.AreEqual("nowplayingtrack", Constants.NowPlayingTrack);
        }

        [Test]
        public void NowPlayingCover_IsCorrect()
        {
            Assert.AreEqual("nowplayingcover", Constants.NowPlayingCover);
        }

        [Test]
        public void NowPlayingLyrics_IsCorrect()
        {
            Assert.AreEqual("nowplayinglyrics", Constants.NowPlayingLyrics);
        }

        [Test]
        public void NowPlayingRating_IsCorrect()
        {
            Assert.AreEqual("nowplayingrating", Constants.NowPlayingRating);
        }

        #endregion

        #region ARiA Constants

        [Test]
        public void PlayerInitiatorAction_IsCorrect()
        {
            Assert.AreEqual("playerinitiatoraction", Constants.PlayerInitiatorAction);
        }

        [Test]
        public void ConfigureAriaHotkeys_IsCorrect()
        {
            Assert.AreEqual("configureariahotkeys", Constants.ConfigureAriaHotkeys);
        }

        #endregion
    }
}
