# MusicBee Remote Plugin v1.5.x

<p align="center">
  <img src="plugin/mbrc.png" alt="MusicBee Remote" height="80">
  <img src="plugin/halrad-jellybee.png" alt="Halrad" height="80">
</p>

[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

A plugin for MusicBee that enables remote control via network clients.

---

## Project Overview

This repository contains both the **MBRC Server Plugin** (production) and **MBRCPVAL** (validation toolkit).

### Project Structure

| Folder               | Type         | Purpose                                     |
| -------------------- | ------------ | ------------------------------------------- |
| `plugin/`            | Production   | MBRC Server Plugin source code for MusicBee |
| `mbrcpval/`          | Development  | Protocol Validator CLI toolkit (52+ tests)  |
| `firewall-utility/`  | Utility      | Windows Firewall configuration helper       |
| `mbrc-plugin.Tests/` | Development  | Unit tests for plugin                       |
| `Documentation/`     | Reference    | Legacy documentation                        |
| `deploy/`            | Distribution | Build output and release packages           |
| `packages/`          | Dependencies | NuGet packages                              |

---

## Documentation Index

### Plugin Documentation (Product)

Documents about **using** the plugin and understanding the protocol.

| Document                                                                      | Purpose                        | Audience                |
| ----------------------------------------------------------------------------- | ------------------------------ | ----------------------- |
| [README.md](README.md)                                                        | This file - project overview   | All users               |
| [plugin_CHANGELOG.md](plugin_CHANGELOG.md)                                    | Version history and changes    | All users               |
| [Plugin Setup](https://halrad.com/MBXRemote/plugin.html)                      | Installation and configuration | End users (WEB)         |
| [Protocol SDK](https://halrad.com/MBXRemote/MBRC-Server-Plugin-Protocol.html) | Protocol v4/4.5 specification  | Client developers (WEB) |

### Validation Documentation (Product)

Documents about **validating** protocol implementations.

| Document                                                                         | Purpose                               | Audience          |
| -------------------------------------------------------------------------------- | ------------------------------------- | ----------------- |
| [mbrcpval/README.md](mbrcpval/README.md)                                         | MBRCPVAL toolkit overview             | Developers, QA    |
| [MBRCPVAL-QUICKSTART.md](mbrcpval/Docs/MBRCPVAL-QUICKSTART.md)                   | Quick start with testing ecosystem    | All users         |
| [mbrcpval/Docs/CRITICALITY-FRAMEWORK.md](mbrcpval/Docs/CRITICALITY-FRAMEWORK.md) | Mandatory/Recommended/Optional levels | Developers, QA    |
| [mbrcpval/Docs/INTEGRATION-PLAN.md](mbrcpval/Docs/INTEGRATION-PLAN.md)           | Step-by-step validation workflow      | CI/CD, QA         |
| [mbrcpval/Docs/PROTOCOL-SDK-MIRROR.md](mbrcpval/Docs/PROTOCOL-SDK-MIRROR.md)     | Protocol reference (MD format)        | Client developers |

### Development Documentation (Project)

Documents about **building and developing** the plugin and tools.

| Document                                                                             | Purpose                           | Audience     |
| ------------------------------------------------------------------------------------ | --------------------------------- | ------------ |
| [mbrcpval/Docs/MBRCPVAL-SPEC.md](mbrcpval/Docs/MBRCPVAL-SPEC.md)                     | MBRCPVAL technical specification  | Contributors |
| [mbrcpval/Docs/MBRCPVAL-IMPLEMENTATION.md](mbrcpval/Docs/MBRCPVAL-IMPLEMENTATION.md) | Implementation architecture       | Contributors |
| [mbrcpval/Docs/MBRCPVAL-MASTERPLAN.md](mbrcpval/Docs/MBRCPVAL-MASTERPLAN.md)         | Project roadmap and vision        | Contributors |
| [mbrcpval/Docs/BACKLOG.md](mbrcpval/Docs/BACKLOG.md)                                 | Missing features and planned work | Contributors |
| [mbrcpval/Docs/ISSUES.md](mbrcpval/Docs/ISSUES.md)                                   | Known bugs and limitations        | Contributors |
| [mbrcpval/Docs/MBRCPVAL-CHANGELOG.md](mbrcpval/Docs/MBRCPVAL-CHANGELOG.md)           | MBRCPVAL version history          | All users    |

---

## About

This is an extended fork of the [MusicBee Remote plugin](https://github.com/musicbeeremote/mbrc-plugin) by Konstantinos Paparas, adding Protocol v4.5 features:

- **ARiA (Arbitrary Remote Initiated Actions)** - Remote keyboard automation
- **Extended track metadata** - Year, rating, bitrate, format fields
- **Album navigation** - Next/previous album (MusicBee 3.1+)
- **Podcast support** - Subscriptions and episodes (MusicBee 3.1+)
- **Protocol negotiation** - Backwards compatible with v4.0 clients

---

## Compatible Clients

| Client                                                                        | Platform | Protocol                 |
| ----------------------------------------------------------------------------- | -------- | ------------------------ |
| [MBXRemote](https://halrad.com/MBXRemote/)                                    | Windows  | v4.5 (full features)     |
| [MusicBee Remote](https://mbrc.kelsos.net/)                                   | Android  | v4.0 (standard features) |
| [MusicBee Remote](https://apps.apple.com/us/app/musicbee-remote/id1476671144) | iOS      | v4.0 (standard features) |

---

## Plugin Installation

### End Users

Download from [MBXRemote Plugin Page](https://halrad.com/MBXRemote/plugin.html#extended-download).

1. Open MusicBee
2. Go to **Edit > Preferences > Plugins**
3. Click **Add Plugin**
4. Select the downloaded ZIP file
5. Restart MusicBee
6. (Optional) Enable ARiA in plugin settings for Initiator Actions

### Plugin Settings

#### IP Filtering (Connection Security)

| Mode         | Description                                                |
| ------------ | ---------------------------------------------------------- |
| **All**      | Accept connections from any IP address (Default)           |
| **Range**    | Accept connections from an IP address range (subnet-style) |
| **Specific** | Whitelist mode - only explicitly listed IPs can connect    |

---

## Development

### Prerequisites

- Visual Studio 2022
- MusicBee installed
- .NET Framework 4.7.2+ (plugin)
- .NET 8.0+ (MBRCPVAL)

### Building the Plugin

```bash
git clone <repo-url>
cd mbrc-plugin-main-server

# Build plugin
build.bat          # Release build (default)
build.bat Debug    # Debug build
```

The build copies `mb_remote.dll` to MusicBee's plugin folder.

### Building MBRCPVAL

```bash
cd mbrcpval
dotnet restore
dotnet build -c Release
```

---

## Integration & Validation

Three testing options are available, each for different use cases:

### Testing Ecosystem

```
┌─────────────────────────────────────────────────────────────────────────────┐
│                     MBRC TESTING ECOSYSTEM                                   │
├─────────────────────────────────────────────────────────────────────────────┤
│  1. PLUGIN SDK                  2. MBXRemote          3. MBRCPVAL            │
│     (Source Code)                  Tester               (Validator)          │
│  ─────────────────             ────────────          ──────────────          │
│  For: Plugin devs              For: Quick checks     For: Full validation   │
│  What: C# source               What: Built-in GUI    What: CLI tool         │
│  Use: Modify plugin            Use: Smoke tests      Use: Conformance       │
└─────────────────────────────────────────────────────────────────────────────┘
```

### 1. MBXRemote Built-in Tester (Quick Checks)

For quick smoke tests without command line:

1. Open MBXRemote
2. Press `Ctrl+Shift+Alt+T`
3. Run quick tests (protocol negotiation, ARiA, browse endpoints)

**Best for:** End users, quick verification, ARiA configuration check

### 2. MBRCPVAL (Comprehensive Validation)

For full protocol conformance testing with criticality levels:

```bash
cd mbrcpval
dotnet build -c Release

# Run mandatory tests only (Bronze certification)
mbrcpval server --host localhost --port 3000 --tags mandatory

# Run production check (Silver certification)
mbrcpval server --host localhost --tags mandatory,recommended --report html -o report.html

# Run full test suite
mbrcpval server --host localhost --suite all
```

**52+ tests** organized by criticality:

- **Mandatory** (14 tests) - Must pass for basic compliance
- **Recommended** (23 tests) - Should pass for good UX
- **Optional** (15 tests) - Nice to have for full features

**Certification Levels:**
| Level | Badge | Requirements |
|-------|-------|--------------|
| Bronze | 🥉 | 100% mandatory tests pass |
| Silver | 🥈 | 100% mandatory + 90% recommended |
| Gold | 🥇 | 100% mandatory + 100% recommended + 80% optional |
| Platinum | 💎 | 100% all tests pass |

**Best for:** Developers, CI/CD pipelines, release validation

### 3. Plugin SDK (For Developers)

The `plugin/` source includes internal `SocketTester.cs` for basic connectivity verification.

See [MBRCPVAL Quick Start](mbrcpval/Docs/MBRCPVAL-QUICKSTART.md) for detailed testing workflows.

---

## CI/CD Integration

Example GitHub Actions workflow:

```yaml
- name: Build Plugin
  run: build.bat Release

- name: Build MBRCPVAL
  run: dotnet build mbrcpval -c Release

- name: Start Mock Server
  run: mbrcpval mock --port 3000 &

- name: Run Protocol Tests
  run: |
    mbrcpval server \
      --host localhost \
      --port 3000 \
      --tags mandatory,recommended \
      --report junit \
      --output test-results.xml

- name: Upload Results
  uses: actions/upload-artifact@v4
  with:
    name: protocol-tests
    path: test-results.xml
```

---

## External Documentation

- [MBXRemote Documentation](https://halrad.com/MBXRemote/) - Windows desktop client
- [Protocol SDK](https://halrad.com/MBXRemote/MBRC-Server-Plugin-Protocol.html) - Protocol specification
- [Plugin Setup](https://halrad.com/MBXRemote/plugin.html) - Installation and configuration
- [MBRC Official Site](https://mbrc.kelsos.net/) - Original MusicBee Remote project

---

## License

Licensed under [GPLv3](https://www.gnu.org/licenses/gpl-3.0).

```
MusicBee Remote Plugin
Copyright (C) 2011-2023 Konstantinos Paparas
Copyright (C) 2025-2026 Halrad llc (extensions)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
```

## Attribution

**MusicBee**: [Steven Mayall](https://getmusicbee.com/) - The ultimate music manager and player for Windows

**MusicBee Plugin API**: This plugin implements the [MusicBee Plugin Interface](https://getmusicbee.com/forum/index.php?topic=19095.0) to integrate with MusicBee. The `MusicBeeInterface.cs` file is provided by Steven Mayall and is not covered by this project's GPL license.

Original plugin by [Konstantinos Paparas](https://github.com/musicbeeremote/mbrc-plugin).

Extended with ARiA, Protocol v4.5, and MBRCPVAL by Halrad LLC.

---

## Other HALRAD MusicBee Projects

- [MBXRemote](https://halrad.com/MBXRemote/) - Windows desktop remote client for MusicBee
- [MusicBee TrueShuffle](https://halrad.com/MBTrueShuffle/) - True shuffle plugin that plays every track once
- [MBXCast](https://halrad.com/mbxcast.html) - Google Caster for MusicBee
- [mb_clouseau](https://github.com/halrad/mb_clouseau) - Trace/debug utility for MusicBee plugin developers

---

## MusicBee Remote for Android

**A huge shoutout to the [MusicBee Remote Android App](https://mbrc.kelsos.net/help/application)!**

The original MusicBee Remote Android application by Konstantinos Paparas is what started it all. This fantastic app lets you control MusicBee from your Android device and inspired the entire remote control ecosystem.

- [Download on Google Play](https://play.google.com/store/apps/details?id=com.kelsos.mbrc)
- [App Documentation](https://mbrc.kelsos.net/help/application)
- [MBRC Project Home](https://mbrc.kelsos.net/)

*Thank you, Kelsos, for creating such an amazing foundation!

*AND Steven for making it all possible with the best Music App on the planet.*

---

## Dependencies

| Package                                                                | Author                          | License      | Purpose                                      |
| ---------------------------------------------------------------------- | ------------------------------- | ------------ | -------------------------------------------- |
| [Newtonsoft.Json](https://github.com/JamesNK/Newtonsoft.Json)          | James Newton-King               | MIT          | JSON protocol serialization                  |
| [NLog](https://github.com/NLog/NLog)                                   | NLog Contributors               | BSD-3-Clause | Structured logging framework                 |
| [ServiceStack.Text](https://github.com/ServiceStack/ServiceStack.Text) | ServiceStack                    | BSD-3-Clause | Fast JSON serialization                      |
| [Fody](https://github.com/Fody/Fody)                                   | Simon Cropp                     | MIT          | IL weaving framework                         |
| [Costura.Fody](https://github.com/Fody/Costura)                        | Simon Cropp, Cameron MacFarland | MIT          | Assembly embedding (single DLL distribution) |

---

## Key Acknowledgements

| Contributor                                       | Contribution                                     |
| ------------------------------------------------- | ------------------------------------------------ |
| [Steven Mayall](https://getmusicbee.com/)         | MusicBee - The ultimate music manager and player |
| [Konstantinos Paparas](https://github.com/kelsos) | Original MBRC Plugin and Protocol                |
| [James Newton-King](https://github.com/JamesNK)   | Newtonsoft.Json                                  |
| [Simon Cropp](https://github.com/simoncropp)      | Fody IL weaving tools                            |

---

*MusicBee Remote Plugin v1.5.26.3 | Updated 2026-01-04*
