# Documentation Publishing Split Plan

**Internal Document**

---

## Overview

The documentation forms a **single cohesive website** at `halrad.com/MBXRemote/` with unified navigation. However, files are **maintained separately** by their respective projects and **published together** to the shared web root.

**Key Principle:** They go together as a whole, but are published and maintained separately.

## Web Root Structure (Same Folder)

```
halrad.com/MBXRemote/
├── index.html           ← MBXRemote (client)
├── download.html        ← MBXRemote (client)
├── docs.html            ← MBXRemote (client)
├── features.html        ← MBXRemote (client)
├── hotkeys.html         ← MBXRemote (client)
├── initiator-actions.html ← MBXRemote (client)
├── appendix.html        ← MBXRemote (client)
│
├── plugin.html          ← PLUGIN (server)
├── MBRC-Server-Plugin-Protocol.html ← PLUGIN (server/SDK)
├── mbrcpval.html        ← PLUGIN (server/validator)
├── plugin_CHANGELOG.md  ← PLUGIN (server)
│
├── downloads/
│   ├── MBXRemote-latest.zip        ← MBXRemote (client)
│   ├── MBRC-Plugin-latest.zip      ← PLUGIN (server)
│   └── Halrad-fork-*_src.zip       ← PLUGIN (server)
│
└── assets/
    └── (shared assets)
```

## Source Ownership

### Plugin Project (mbrc-plugin-main-server)

**Owns & Maintains:**

| File | Purpose |
|------|---------|
| `plugin.html` | Plugin installation, ARiA, settings |
| `MBRC-Server-Plugin-Protocol.html` | Protocol SDK (full specification) |
| `mbrcpval.html` | MBRCPVAL validator documentation |
| `plugin_CHANGELOG.md` | Plugin version history |
| `downloads/MBRC-Plugin-*.zip` | Plugin releases |
| `downloads/Halrad-fork-*_src.zip` | Plugin source |

**Markdown Mirrors (in plugin repo):**

| File | Purpose |
|------|---------|
| `Documentation/PROTOCOL-SDK.md` | Markdown mirror of Protocol SDK |
| `mbrcpval/Docs/MBRCPVAL-HTML-MIRROR.md` | Markdown mirror of mbrcpval.html |
| `plugin_CHANGELOG.md` | Authoritative changelog |

### MBXRemote Project (tntctl)

**Owns & Maintains:**

| File | Purpose |
|------|---------|
| `index.html` | MBXRemote home page |
| `download.html` | MBXRemote downloads |
| `docs.html` | MBXRemote user documentation |
| `features.html` | MBXRemote feature list |
| `hotkeys.html` | MBXRemote keyboard shortcuts |
| `initiator-actions.html` | ARiA action syntax (user-facing) |
| `appendix.html` | MBXRemote appendix |
| `downloads/MBXRemote-*.zip` | Client releases |

## Publishing Workflow

### From Plugin Project

```bash
# Build plugin, then copy to web folder
cd mbrc-plugin-main-server
./build.bat Release

# Copy HTML files
copy Documentation\plugin.html ..\tntctl\deploy\www\
copy Documentation\MBRC-Server-Plugin-Protocol.html ..\tntctl\deploy\www\
copy Documentation\mbrcpval.html ..\tntctl\deploy\www\

# Copy downloads
copy deploy\MBRC-Plugin-latest.zip ..\tntctl\deploy\www\downloads\
copy deploy\*_src.zip ..\tntctl\deploy\www\downloads\
```

### From MBXRemote Project

```bash
# Build client, then update web folder
cd tntctl
./build.bat Release

# HTML files already in place (owned here)
# Just update downloads
copy deploy\MBXRemote-latest.zip deploy\www\downloads\
```

## Cross-References

### Links from MBXRemote docs → Plugin docs

These work because same web folder:
- `plugin.html` → Plugin page
- `MBRC-Server-Plugin-Protocol.html` → Protocol SDK
- `mbrcpval.html` → Validator docs

### Links from Plugin docs → MBXRemote docs

These also work because same web folder:
- `index.html` → MBXRemote home
- `initiator-actions.html` → ARiA syntax (user-facing)

## Existing Markdown Mirrors

The plugin project already maintains markdown versions of key HTML documents:

| Markdown Source | HTML Target | Location |
|-----------------|-------------|----------|
| `mbrcpval/Docs/PROTOCOL-SDK-MIRROR.md` | `MBRC-Server-Plugin-Protocol.html` | Protocol specification |
| `mbrcpval/Docs/MBRCPVAL-HTML-MIRROR.md` | `mbrcpval.html` | Validator documentation |
| `plugin_CHANGELOG.md` | (linked directly) | Plugin version history |

These serve as the **authoritative source** for protocol documentation. Edit markdown first, then generate/update HTML for publishing.

## Version Coordination

When updating Protocol SDK:

1. Edit `mbrcpval/Docs/PROTOCOL-SDK-MIRROR.md` (authoritative source)
2. Regenerate `MBRC-Server-Plugin-Protocol.html` from markdown
3. Copy to web folder for publishing
4. Update plugin_CHANGELOG.md if protocol changes

When updating MBXRemote features:

1. Edit HTML directly in `tntctl/deploy/www/`
2. Update `docs.html`, `features.html` as needed
3. If protocol changes, coordinate with plugin project

## Navigation Updates

Both navbars share the same structure. When adding new pages:

1. Add link to navbar in **both** plugin.html template and MBXRemote HTML files
2. Keep cross-links section (`Chromecast`, `TrueShuffle`, `Clouseau`) consistent

---

*Document created for internal coordination*
