# ARiA Refactoring Plan

## Current State

ARiA (Arbitrary Remote Initiated Actions) implementation is in `InitiatorActionHandler.cs` within the plugin's `AndroidRemote/Commands` namespace.

**Current location:** `plugin/AndroidRemote/Handlers/InitiatorActionHandler.cs`

**Current commands:**
- `sndKeys` / `sendkeys` - Send keyboard input
- `delay` / `wait` - Add delay between commands
- `mouseClick` / `click` - Remote mouse clicks
- `volume` / `vol` - Windows system volume control
- `restart` - Restart MusicBee or host system
- `run` / `exec` / `launch` - Launch programs on host

## Problem

1. The `AndroidRemote` namespace is legacy naming - not Android-specific
2. ARiA commands (mouseClick, volume, restart, run) are generic Windows automation - not MusicBee-specific
3. All code is coupled to the plugin when it could be reusable

## Proposed Architecture

```
Halrad (Company)
├── tntctl (Remote control library/app)
│   └── Core remote control functionality
│   └── Could contain ARiA execution engine
│
├── mbrc-plugin (MusicBee plugin)
│   └── Protocol handling (receives playerinitiatoraction)
│   └── Gets MB window handle
│   └── Calls ARiA library for execution
│
└── ARiA (Protocol/feature name)
    └── Defines the command format/protocol
    └── NOT a separate library - just the specification
```

## Decision

**Keep ARiA in the plugin for now.**

Rationale:
1. Current implementation works
2. Not enough reuse cases to justify a separate library
3. Adding build complexity not worth it yet
4. Can refactor later if tntctl needs the same functionality

## Future Considerations

If refactoring becomes necessary:

1. Create `Halrad.RemoteAutomation` or similar library containing:
   - Command parser
   - NativeMethods (user32.dll P/Invoke)
   - ExecuteMouseClick, ExecuteVolume, ExecuteRestart, ExecuteRun
   - Window focus helper (takes IntPtr handle)

2. Plugin becomes thin wrapper:
   ```csharp
   // Plugin just does:
   var handle = _api.MB_GetWindowHandle();
   remoteAutomation.Execute(script, focusWindow: handle);
   ```

3. tntctl could use same library for local automation if needed

## Namespace Cleanup (Optional Future Work)

The `AndroidRemote` namespace is misleading. Options:
1. Leave as-is (least churn)
2. Rename to `MusicBeePlugin.Remote` (breaking change)
3. Add new namespace, deprecate old (migration path)

**Recommendation:** Leave as-is. It's internal to the plugin and doesn't affect the protocol.

## Status

- [x] All ARiA commands implemented (v1.5.25.1224)
- [x] Documentation updated
- [ ] Refactoring to library - DEFERRED (not needed now)
- [ ] Namespace cleanup - DEFERRED (not worth the churn)

## Conclusion

No refactoring at this time. The current implementation is sufficient. Revisit if:
- tntctl needs same automation capabilities
- Another project needs ARiA execution
- Code becomes harder to maintain
