using System.Windows.Forms;
using MusicBeePlugin.Clouseau.Logging;
using MusicBeePlugin.Clouseau.UI.Theme;

namespace MusicBeePlugin.Clouseau.UI.Tabs
{
    /// <summary>
    /// Events tab displaying the full log viewer with event history.
    /// </summary>
    public class EventsTab : DashboardTabBase
    {
        private readonly LogViewerPanel _logViewer;

        /// <summary>
        /// Gets the number of log entries.
        /// </summary>
        public int EntryCount => _logViewer?.EntryCount ?? 0;

        /// <summary>
        /// Creates a new Events tab.
        /// </summary>
        /// <param name="maxEntries">Maximum entries to keep in buffer.</param>
        public EventsTab(int maxEntries = 5000)
        {
            _logViewer = new LogViewerPanel(maxEntries)
            {
                Dock = DockStyle.Fill,
                ShowDashboardButton = false, // Already in Dashboard
                ShowStatusBar = false // Dashboard has its own status bar
            };
            DarkTheme.Apply(_logViewer);

            Controls.Add(_logViewer);
        }

        /// <summary>
        /// Adds a log entry to the viewer.
        /// </summary>
        public void AddEntry(LogEntry entry)
        {
            _logViewer?.AddEntry(entry);
        }

        /// <summary>
        /// Adds a log entry with individual fields.
        /// </summary>
        public void AddEntry(string category, string level, string eventType, string details)
        {
            _logViewer?.AddEntry(category, level, eventType, details);
        }
    }
}
