@echo off
REM ============================================================================
REM mb_clouseau Build Wrapper
REM Uncovering clues with MusicBee Clouseau
REM ============================================================================
REM Usage: build.cmd [Debug|Release]
REM        build.cmd           - Builds Debug configuration
REM        build.cmd Debug     - Builds Debug configuration
REM        build.cmd Release   - Builds Release configuration
REM ============================================================================

setlocal enabledelayedexpansion

REM Set default configuration (Release for double-click)
set CONFIG=Release
if not "%~1"=="" set CONFIG=%~1

REM Validate configuration
if /i not "%CONFIG%"=="Debug" if /i not "%CONFIG%"=="Release" (
    echo Error: Invalid configuration '%CONFIG%'. Use 'Debug' or 'Release'.
    exit /b 1
)

echo.
echo ============================================================================
echo mb_clouseau Build - %CONFIG%
echo ============================================================================
echo.

REM Run PowerShell build script
powershell -NoProfile -ExecutionPolicy Bypass -File "%~dp0build.ps1" -Configuration %CONFIG%

if %ERRORLEVEL% neq 0 (
    echo.
    echo Build FAILED with error code %ERRORLEVEL%
    exit /b %ERRORLEVEL%
)

echo.
echo Build completed successfully.
exit /b 0
