# mb_clouseau - MusicBee Clouseau

<p align="center">
  <img src="HALRAD_mb_Clouseau.png" alt="MusicBee Clouseau" width="256">
</p>

**Uncovering clues with MusicBee Clouseau.**

*A MusicBee trace/debug utility for plugin developers.*

Like an innspector investigating a case, this plugin observes and logs everything happening inside MusicBee - every event, every API call, every notification. Perfect for understanding the MusicBee plugin API and debugging your own plugins.

---

## Purpose

mb_clouseau serves as:

1. **Event Logger** - Subscribe to ALL notification types and log everything MusicBee does
2. **API Reference** - Demonstrate every available MusicBee API method
3. **Debug Utility** - Watch what happens when other plugins interact with MusicBee
4. **Learning Tool** - Understand the MusicBee plugin lifecycle and event flow

## Features

### Logging & Data Capture

- **Full Event Subscription** - Logs all 40+ notification types with rich context
- **Full Context Logging** - ALL event data saved to disk (Artist, Title, Album, Duration, Bitrate, Position, etc.)
- **JSON Lines Export** - `events.jsonl` with complete event context for easy parsing with jq, Python, etc.
- **Rich Details Dialog** - Double-click any event to see full context in scrollable dialog
- **Multiple Log Formats** - events.log (pipe-delimited), events.jsonl (JSON Lines), clouseau.json (structured)

### UI & Dashboard

- **Dockable Panel** - Live log viewer with category filter, Clear, Dashboard, Pop Out, Settings links
- **Flyout Menu** - Tools > Clouseau submenu with Dashboard, Settings, Live Events options
- **Dashboard** - Full tabbed UI for events, metrics, plugins, and diagnostics (1920x900)
- **Pop-Out Window** - Full-size log viewer with larger fonts (1350x700)
- **Settings Dialog** - Tabbed configuration UI (900x750) with proper control spacing

### Introspection & Metrics

- **System Metrics** - CPU, memory, disk, CLR/GC stats, audio device info
- **Plugin Discovery** - Lists all loaded plugins with version/author info
- **API Interception** - Track API call frequency, duration, and anomalies
- **State Dumps** - On-demand deep snapshots of MusicBee environment

### Advanced Introspection Tools

- **UI Gallery** - Screenshot mode capturing all plugin dialogs with auto-refresh
- **App Spy Overlay** - Transparent overlay highlighting UI elements under cursor
- **Method Invoker** - Execute arbitrary methods via reflection with parameter UI
- **Event Inspector** - View, invoke, and detach event handlers on any control
- **Menu Inspector** - Walk menu hierarchies and invoke menu items programmatically

## Use Cases

- **Plugin Development** - See exactly what events fire when
- **Debugging** - Understand why your plugin isn't receiving expected events
- **API Discovery** - Learn what data is available from each API method
- **Plugin Spy Mode** - Watch what other plugins are doing

## Installation

1. Download `mb_clouseau.dll` from Releases
2. Copy to MusicBee Plugins folder
3. Restart MusicBee
4. Enable in Preferences > Plugins

## Requirements

- MusicBee 3.1 or later
- Windows 7/8/10/11
- .NET Framework 4.8

## Building

```bash
dotnet build mb_clouseau.csproj -c Debug
dotnet build mb_clouseau.csproj -c Release
```

## Documentation

- [SPEC.md](SPEC.md) - Technical specification
- [CHANGELOG.md](CHANGELOG.md) - Version history

## Dependencies

| Package                                                                    | Author            | License      | Purpose                              |
| -------------------------------------------------------------------------- | ----------------- | ------------ | ------------------------------------ |
| [Newtonsoft.Json](https://github.com/JamesNK/Newtonsoft.Json)              | James Newton-King | MIT          | JSON serialization for event logging |
| [NLog](https://github.com/NLog/NLog)                                       | NLog Contributors | BSD-3-Clause | Structured logging framework         |
| [System.Diagnostics.PerformanceCounter](https://github.com/dotnet/runtime) | Microsoft         | MIT          | Performance metrics collection       |
| [System.Management](https://github.com/dotnet/runtime)                     | Microsoft         | MIT          | System information gathering         |

## Attribution

**MusicBee**: [Steven Mayall](https://getmusicbee.com/) - The ultimate music manager and player for Windows

**MusicBee Plugin API**: This plugin implements the [MusicBee Plugin Interface](https://getmusicbee.com/forum/index.php?topic=19095.0) to integrate with MusicBee. The `MusicBeeInterface.cs` file is provided by Steven Mayall and is not covered by this project's GPL license.

**Inspector Theme**: The Clouseau name and detective theme are inspired by the classic Inspector Clouseau character - we investigate what's happening inside MusicBee with the same determination (if not quite the same grace).

## Other HALRAD MusicBee Projects

- [MBXRemote](https://halrad.com/MBXRemote/) - Windows desktop remote client
- [MBXCast](https://halrad.com/mbxcast.html) - Google Caster for MusicBee
- [MusicBee TrueShuffle](https://halrad.com/MBTrueShuffle/) - True shuffle plugin
- [MBRC Plugin](https://halrad.com/MBXRemote/plugin.html) - MusicBee Remote Control server plugin

## License

[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

GPL-3.0 with MusicBee Linking Exception - See [LICENSE](LICENSE) for details.

**Note**: This license includes a linking exception allowing dynamic linking with MusicBee player, as per the [GPL FAQ on plugins](https://www.gnu.org/licenses/gpl-faq.html#GPLPluginsInNF).
