@echo off
REM ============================================================================
REM mb_clouseau Package Script
REM Uncovering clues with MusicBee Clouseau
REM ============================================================================
REM Usage: package.cmd [Debug|Release]
REM        package.cmd           - Packages Release build
REM        package.cmd Release   - Packages Release build
REM        package.cmd Debug     - Packages Debug build
REM ============================================================================

setlocal enabledelayedexpansion

REM Set default configuration
set CONFIG=Release
if not "%~1"=="" set CONFIG=%~1

REM Validate configuration
if /i not "%CONFIG%"=="Debug" if /i not "%CONFIG%"=="Release" (
    echo Error: Invalid configuration '%CONFIG%'. Use 'Debug' or 'Release'.
    exit /b 1
)

echo.
echo ============================================================================
echo mb_clouseau Package - %CONFIG%
echo ============================================================================
echo.

REM Run PowerShell package script
powershell -NoProfile -ExecutionPolicy Bypass -File "%~dp0package.ps1" -Configuration %CONFIG%

if %ERRORLEVEL% neq 0 (
    echo.
    echo Package FAILED with error code %ERRORLEVEL%
    exit /b %ERRORLEVEL%
)

echo.
echo Package completed successfully.
pause
exit /b 0
