@echo off
setlocal enabledelayedexpansion

REM ============================================================================
REM mb_clouseau Web Deploy Script
REM Uncovering clues with MusicBee Clouseau
REM ============================================================================
REM Deploys www folder to Z:\mbClouseau (https://halrad.com/mbClouseau)
REM ============================================================================

:: Logging setup
set "LOGFILE=%~dp0publishing.log"
set "START_TIME=%date% %time%"

:: Get epoch from latest archive
:: Filename format: MusicBee-Clouseau-0.1.0-XXXXXXXX.zip
set "EPOCH=unknown"
for /f "tokens=*" %%f in ('dir /b /o-d "%~dp0archive\MusicBee-Clouseau-*.zip" 2^>nul') do (
    set "ZIPNAME=%%~nf"
    goto :parseepoch
)
:parseepoch
:: Extract epoch (last segment after final hyphen)
if defined ZIPNAME (
    for %%i in ("!ZIPNAME:-=" "!") do set "EPOCH=%%~i"
)

echo.
echo ============================================================================
echo   mb_clouseau Web Deploy
echo   Epoch: %EPOCH%
echo   Destination: Z:\mbClouseau
echo   URL: https://halrad.com/mbClouseau
echo ============================================================================
echo.

:: Check if Z: drive is mounted
if exist Z:\ (
    echo [OK] Z: drive is mounted.
) else (
    echo [..] Z: drive not mounted. Connecting to WebDAV...

    :: Try to map the drive using net use
    net use Z: "\\eltekco.com@SSL@2078\DavWWWRoot" /persistent:no

    if errorlevel 1 (
        echo [..] Failed to map drive automatically. Trying shortcut...
        start "" "C:\bin\eltekco.com Secure WebDisk.lnk"

        echo [..] Waiting for Z: drive to become available...
        :waitloop
        timeout /t 2 /nobreak >nul
        if not exist Z:\ goto :waitloop
    )
    echo [OK] Z: drive connected.
)

:: Create destination if needed
if not exist "Z:\mbClouseau" (
    echo [..] Creating Z:\mbClouseau...
    mkdir "Z:\mbClouseau"
)

:deploy
echo.
echo [..] Deploying to Z:\mbClouseau...
echo.

:: Run robocopy with progress visible
robocopy "%~dp0www" "Z:\mbClouseau" /mir /njh /njs /ndl /nc /ns

:: Capture exit code (robocopy uses non-standard codes)
set "ROBO_EXIT=%errorlevel%"

:: Count files in www folder
set "FILE_COUNT=0"
for /f %%c in ('dir /s /b "%~dp0www\*" 2^>nul ^| find /c /v ""') do set "FILE_COUNT=%%c"

:: Get end time
set "END_TIME=%date% %time%"

:: Write to log
echo [%START_TIME%] Started deploy, Epoch=%EPOCH% >> "%LOGFILE%"
echo [%END_TIME%] Completed, Files=%FILE_COUNT%, Dest=Z:\mbClouseau >> "%LOGFILE%"
echo. >> "%LOGFILE%"

:: Determine status from robocopy exit code
:: 0 = No files copied, no failures
:: 1 = Files copied successfully
:: 2 = Extra files/dirs detected (with /MIR this means deletions)
:: 4 = Mismatched files/dirs detected
:: 8+ = Errors occurred
if %ROBO_EXIT% GEQ 8 (
    echo.
    echo [WARN] Robocopy reported errors (exit code %ROBO_EXIT%)
) else (
    echo.
    echo [OK] Robocopy completed (exit code %ROBO_EXIT%)
)

echo.
echo ============================================================================
echo   Deploy Complete
echo ============================================================================
echo   Files:       %FILE_COUNT%
echo   Epoch:       %EPOCH%
echo   Destination: Z:\mbClouseau
echo   URL:         https://halrad.com/mbClouseau
echo ============================================================================
echo.
echo Logged to: %LOGFILE%
echo.
pause
