# Changelog

All notable changes to mb_clouseau will be documented in this file.

**See also:** [MBXRemote](https://halrad.com/MBXRemote/) | [MBXCast](https://halrad.com/mbxcast.html) | [TrueShuffle](https://halrad.com/MBTrueShuffle/)

---

## [1.0.26.1] - 2026-01-01

### Critical Fix

- **Dockable Panel Threading Fix** - Fixed blank panel on MusicBee startup
  - Root cause: MusicBee calls `OnDockablePanelCreated` from a background thread
  - WinForms controls must be created on the UI thread
  - Fix: Use `panel.InvokeRequired` + `panel.Invoke()` to marshal control creation to UI thread
  - Also calls `MB_RefreshPanels()` after 500ms to ensure panel is rendered

### Inspector Forms Fix

- **SplitterDistance Error Fix** - Fixed "SplitterDistance must be between Panel1MinSize and Width - Panel2MinSize" error in:
  - Method Invoker form
  - Event Inspector form
  - Menu Inspector form
  - Fix: Defer SplitterDistance and Panel min sizes to `Shown` event instead of constructor

### Dashboard UI Polish

- **Invoke Tab** - Increased header height (70px), moved Open button right (X=250)
- **Handlers Tab** - Reduced Event/Menu button font size (9F → 8F)
- **About Dialog** - Adjusted version label position (down 20px), OK button position (up 25px)
- **Button Font Sizes** - Consistent 8F font across all dashboard action buttons

### UI Embedding & Audio Subsystem Coverage

Complete A+++ coverage for UI embedding, panels, artwork, visualizers, audio metrics, and automation.

### New Introspection Classes

- **PanelRegistry** - Tracks panel registrations with full lifecycle:
  - Panel handle, control, dock location, owner plugin
  - Create/resize/visibility/remove state changes
  - State history per panel and global history
  - Summary with panels by dock location and plugin

- **ArtworkPipeline** - Tracks artwork request pipeline:
  - NowPlaying, Library, and Artist picture requests
  - Load duration, success/failure, image dimensions
  - Statistics: average load time, success rate, bytes loaded
  - Request history for performance analysis

- **VisualizerRegistry** - Tracks visualizer state:
  - Available visualizers and default visualizer
  - Current visualizer and window state
  - State change history with from/to tracking

- **WindowTracker** - Main window state tracking:
  - Win32 window details (bounds, style, class)
  - Minimize/maximize/visible state detection
  - Window state change history

### Enhanced AudioMetrics (Complete Rewrite)

- **Full MusicBee API Integration** - Real API calls vs placeholder code:
  - Output device enumeration via `Player_GetOutputDevices`
  - Volume, mute, DSP state (equalizer, crossfade, ReplayGain)
  - Current track audio properties (SampleRate, Channels, Format, Bitrate)

- **Spectrum & Waveform Capture**:
  - `CaptureSpectrumData()` - FFT spectrum with band levels (Sub-bass, Bass, Mid, Treble)
  - `CaptureWaveformData()` - Waveform graph with RMS and clipping detection
  - Configurable history size for analysis

- **Extended MetricsSnapshot Fields**:
  - AudioChannels, AudioFormat, AudioBitrate
  - Volume, IsMuted, DspEnabled, EqualizerEnabled
  - CrossfadeEnabled, ReplayGainMode, AvailableDeviceCount

### Enhanced Event Context

- **EmbedInPanel** - Panel bounds for all dock types (ApplicationWindow, TrackAndArtistPanel, MainPanel)
- **ApplicationWindowChanged** - Rich Win32 details via SpyHelper (bounds, style, class, minimize/maximize state)
- **NowPlayingArtworkReady** - Album, embedded artwork status, artist picture URLs

### CommandRegistry (Gap 5)

- Tracks MB_RegisterCommand calls with source plugin detection
- Tracks MB_AddMenuItem registrations with menu path and hotkey
- Tracks MB_InvokeCommand invocations with timing and success
- Provides command/menu counts and invocation history

### SyncTracker (Gap 6)

- Tracks individual file sync operations (copy/delete)
- Records start time, end time, duration, success/failure
- Session summary: files synced, files deleted, errors
- Failed file list for error context

---

## [0.3.0] - 2026-01-01

### A+++ Event Context Coverage

- **Enhanced TrackChanged Context** - Now captures 40+ properties per track:
  - Core Metadata: Artist, AlbumArtist, Title, Album, Genre, Year, TrackNo, TrackCount, DiscNo, DiscCount, Composer, Rating, RatingLove, BPM, Comment, Mood, Grouping, Publisher, Encoder
  - Audio Properties: Duration, Bitrate, Format, Kind (codec), SampleRate, Channels, FileSize (with formatted values)
  - ReplayGain: Track and Album gain values
  - Library Statistics: DateAdded, DateModified, LastPlayed, PlayCount, SkipCount, Status
  - Queue Context: QueueIndex, HasNextTrack, HasPriorTrack

- **Enhanced PlayStateChanged Context** - Comprehensive player state:
  - All player modes: Shuffle, Repeat, ReplayGain, Crossfade, AutoDJ, StopAfterCurrent
  - DSP state: EqualizerEnabled, DspEnabled, ScrobbleEnabled
  - Volume with mute state
  - Active output device and device count
  - Current track audio properties when playing (SampleRate, Channels, Format, Bitrate)

- **Enhanced VolumeChanged Context** - Before/after tracking:
  - Previous volume, current volume, delta values
  - Volume direction indicator (Up/Down/None)

### New Tracking Infrastructure

- **CommandRegistry** (new class) - Tracks command/menu registrations:
  - Records MB_RegisterCommand calls with source plugin detection
  - Records MB_AddMenuItem registrations with menu path and hotkey
  - Tracks MB_InvokeCommand invocations with timing and success status
  - Provides command/menu counts and invocation history

- **SyncTracker** (new class) - Rich sync operation tracking:
  - Tracks individual file sync operations (copy/delete)
  - Records start time, end time, duration, success/failure
  - Provides session summary: files synced, files deleted, errors
  - Captures failed file list for error context

- **Enhanced Playlist Context** - Queries playlist details:
  - Total playlist count in library
  - Created/Updated playlist name, path, type, file count
  - Playlist type enumeration (M3u, Xspf, Asx, etc.)

- **Enhanced SyncCompleted Context** - Uses SyncTracker for rich data:
  - Sync duration with formatted time
  - Files synced and deleted counts
  - Error count with failed file names
  - Device name being synced

---

## [0.2.1] - 2026-01-01

### Changed

- **PluginType: PanelView → General** - Changed from `PluginType.PanelView` to `PluginType.General` so MusicBee displays `_about.Name` ("Clouseau") in the Plugins list instead of the DLL filename
  - **Trade-off**: Loses official support for dockable panels via `CreatePanelView()`
  - Configuration panel via `Configure()` still works
  - `_about.Name` = "Clouseau" now displays correctly
  - Dockable panel still appears to function (MusicBee may not strictly enforce type)

- **Configure Button Styling** - Added MusicBee skin color integration
  - Buttons now use `Setting_GetSkinElementColour()` for BackColor, ForeColor, BorderColor
  - Matches mbrc-plugin button appearance
  - Button height increased to 40px for consistency

### Technical Note: PluginType Differences

| Property | `PluginType.General` | `PluginType.PanelView` |
|----------|---------------------|------------------------|
| Display name in Plugins list | Uses `_about.Name` | Uses DLL filename |
| Dockable panels | May still work | Officially supported |
| Configuration | `Configure()` works | `Configure()` works |

---

## [0.2.0] - 2026-01-01

### Enhanced Logging & Data Capture

- **Full Context Logging** - ALL event context data now written to disk logs (Artist, Title, Album, Duration, Bitrate, Position, etc.)
- **JSON Lines Format** - New `events.jsonl` file with complete event data for easy parsing
- **ISO 8601 Timestamps** - Both human-readable and ISO timestamps in log entries
- **Sequence Numbers** - Each event numbered for correlation and ordering

### Rich Event Details Dialog

- **Double-Click Details** - Click any log entry to see full context in scrollable dialog
- **Formatted Context Display** - All captured data displayed with labels (Artist, Title, Duration, etc.)
- **Event Type Info** - Shows event name, numeric value, category, and sequence number
- **Copy-Friendly** - Monospace font, selectable text for debugging

### UI Polish & Sizing

- **Larger Settings Dialog** - 900x750 form with properly spaced controls (was 600x500)
- **Wider Dashboard** - 1920x900 default size with auto-sizing columns
- **Live Event Log Window** - 1350x700 with larger buttons (100x40) and 60px toolbar
- **Panel Header Redesign** - FlowLayoutPanel with: Category dropdown (110px), Clear, Dashboard, Pop Out, Settings links, scroll checkbox
- **Taller Status Bars** - 40px status bars for better readability
- **Bigger Diagnostics Buttons** - 160x50 buttons with larger fonts

### Menu Integration

- **Flyout Submenu** - Tools > Clouseau with Dashboard, Settings, Live Events items
- **Settings Link in Panel** - Direct access to settings from docked panel header

### Log File Structure

- **events.log** - Pipe-delimited format: `timestamp|level|category|event|eventId|message|source`
- **events.jsonl** - JSON Lines with ALL context properties for parsing
- **clouseau.json** - Full structured JSON log with event properties
- **clouseau.log** - Human-readable main log

### Settings Dialog Improvements

- **All Tabs Fixed** - Proper control spacing on General, Metrics, Introspection, Advanced, UI, Export tabs
- **Wider Controls** - Numeric inputs 100-120px wide, no label overlap
- **Taller Buttons** - OK/Cancel/Apply buttons 90x40

---

## [0.1.0] - 2026-01-01

### Core Features

- **Full Event Subscription** - Subscribes to all 4 notification flags (PlayerEvents, DataStreamEvents, TagEvents, DownloadEvents)
- **40+ Event Types** - Logs all NotificationType events with rich context
- **Structured Logging** - Timestamped, categorized, searchable log entries via LogManager
- **Dockable Panel** - Real-time log viewer integrated into MusicBee with auto-scroll
- **File Logging** - Persistent rotating log files (core, events, metrics, performance, errors)
- **Settings System** - JSON-based configuration with 9 settings sections
- **State Management** - Session tracking, event counts, persistent state

### Dashboard

- **Overview Tab** - Session info, event counts, data path
- **Event Counts Tab** - ListView with columns showing event types and counts
- **Settings Tab** - Enable logging, open logs folder, delete data on uninstall option
- **Diagnostics Tab** - State dump functionality capturing complete MusicBee environment
- **Plugins Tab** - Discover and list all installed plugins with metadata

### UI Components

- **Log Viewer Panel** - Compact panel for MusicBee dock with category filter
- **Pop-Out Window** - Full-size log viewer with larger fonts and detailed view
- **Link-based Actions** - Clear, Dashboard, Pop Out links in panel header
- **Color-coded Logs** - By level (error/warn/info/debug) and category (player/queue/tags)

### Introspection

- **Plugin Discovery** - Scans and loads plugin assemblies to extract PluginInfo
- **State Dumper** - Comprehensive environment snapshot (player, threads, memory, assemblies)
- **Reflection Explorer** - Deep .NET introspection for UI trees, events, methods (Phase 4 preview)

### Performance Monitoring

- **API Interceptor** - Wraps MusicBee API delegates to track call timing
- **Slow Call Detection** - Configurable thresholds (100ms warn, 500ms error)
- **Metrics Collector** - System metrics (CPU, memory, disk, network, CLR, audio)

### Settings & Configuration

- **Uninstall Data Option** - Checkbox to preserve or delete logs on uninstall (checked by default)
- **Logging Outputs** - Configurable file paths, max sizes, rotation policies
- **Format Settings** - Timestamp format, thread/process IDs, call site info
- **Performance Thresholds** - Warn/error thresholds for API call timing

### Advanced Introspection Tools

- **UI Gallery** - Screenshot mode capturing all plugin dialogs with auto-refresh
- **App Spy Overlay** - Transparent click-through overlay highlighting UI elements under cursor
- **Method Invoker** - Execute arbitrary methods via reflection with parameter input UI
- **Event Inspector** - View, invoke, and detach event handlers on any control
- **Menu Inspector** - Walk menu hierarchies and invoke menu items programmatically

### Technical

- Target: MusicBee 3.1+ (API revision 53)
- Framework: .NET Framework 4.8
- State stored in `%AppData%\MusicBee\mb_clouseau\`
- ILRepack for single-DLL deployment with Newtonsoft.Json

---

## Project History

### 2026-01-01 - Version 0.2.0

- Full context logging to disk (events.jsonl with all event data)
- Rich event details dialog on double-click
- Major UI sizing improvements across all dialogs
- Flyout menu under Tools > Clouseau
- Panel header redesign with FlowLayoutPanel
- Settings dialog control spacing fixes

### 2026-01-01 - Version 0.1.0

- Complete core implementation
- All major features functional
- Dashboard with 5 tabs (Overview, Events, Settings, Diagnostics, Plugins)
- Settings with uninstall data option
- Win32 assembly info for Halrad LLC
- Phase 4 Advanced Introspection: UI Gallery, App Spy Overlay, Method Invoker, Event Inspector, Menu Inspector

### 2026-01-01 - Project Created

- Initial project structure
- README.md - Project overview
- SPEC.md - Technical specification with full API reference
- CHANGELOG.md - This file

### Origin

mb_clouseau originated from debug logging work done on:
1. **TrueShuffle** (formerly RADomizer) - Debug logging for shuffle events
2. **MBXCast** (Chromecast plugin) - Structured logging infrastructure

The idea evolved into a standalone "plugin spy" utility that demonstrates and logs the complete MusicBee plugin API.

---

*Inspector Clouseau would be proud.*
