using System;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;

namespace MusicBeePlugin
{
    [DataContract]
    public class ShuffleSettings
    {
        [DataMember(Name = "enabled")]
        public bool Enabled { get; set; } = true;

        [DataMember(Name = "playThreshold")]
        public double PlayThreshold { get; set; } = 0.5;  // 50%

        [DataMember(Name = "autoReset")]
        public bool AutoReset { get; set; } = false;

        [DataMember(Name = "showPanel")]
        public bool ShowPanel { get; set; } = true;

        [DataMember(Name = "showNotifications")]
        public bool ShowNotifications { get; set; } = true;

        public void Save(string filePath)
        {
            try
            {
                var directory = Path.GetDirectoryName(filePath);
                if (!string.IsNullOrEmpty(directory) && !Directory.Exists(directory))
                {
                    Directory.CreateDirectory(directory);
                }

                var serializer = new DataContractJsonSerializer(typeof(ShuffleSettings));
                using (var stream = new FileStream(filePath, FileMode.Create))
                {
                    serializer.WriteObject(stream, this);
                }
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine($"Failed to save settings: {ex.Message}");
            }
        }

        public static ShuffleSettings Load(string filePath)
        {
            try
            {
                if (!File.Exists(filePath))
                {
                    return new ShuffleSettings();
                }

                var serializer = new DataContractJsonSerializer(typeof(ShuffleSettings));
                using (var stream = new FileStream(filePath, FileMode.Open))
                {
                    return (ShuffleSettings)serializer.ReadObject(stream);
                }
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine($"Failed to load settings: {ex.Message}");
                return new ShuffleSettings();
            }
        }
    }
}
