# MusicBeeRADomizer

![MusicBeeRADomizer Logo](mb_radomizer_512.png)

**Because someone had to do it. Apparently.**

MusicBeeRADomizer exists because, apparently, the universe demanded a plugin dedicated to "true randomness" in a music player. Yes. This is where we are now.

While most people simply press Shuffle and move on with their lives, MusicBeeRADomizer steps in with the solemn duty of correcting an injustice no one asked about. It injects "entropy" into your playlist with the seriousness of a nuclear regulator overseeing a toaster. Tracks are selected with mathematically verified fairness, because nothing says "relax and enjoy your music" like a probability distribution.

Is this necessary? Absolutely not. Will it change your life? Also no. But here it is anyway — a fully operational chaos engine for the people on Earth who care this much about shuffle integrity.

---

## What It Actually Does

Master Shuffle treats your library like a deck of cards:

- Every track plays exactly once before any repeats
- State persists across restarts, updates, reboots
- See your progress through the library
- Reset anytime to start fresh

## Features

- **Persistent shuffle state** - survives restarts, updates, everything
- **Progress tracking** - see how much of your library you've heard
- **Configurable threshold** - choose when a track counts as "played"
- **Library aware** - automatically includes new tracks
- **Simple reset** - start fresh with one click

## Installation

1. Download the latest release
2. Copy `mb_MasterShuffle.dll` to your MusicBee Plugins folder
3. Restart MusicBee
4. Enable in Preferences > Plugins

## Usage

Once enabled, Master Shuffle automatically tracks your listening. A progress panel shows your journey through your library:

```
Master Shuffle
Progress: ████████░░░░░░ 3,421 / 12,847
26.6% complete

[Reset] [Settings]
```

## Requirements

- MusicBee 3.1 or later
- Windows 7/8/10/11

## Building

See [SPEC.md](SPEC.md) for technical details and build instructions.

## License

GPL3 - See [LICENSE](LICENSE) for details.

## Other HALRAD MusicBee Projects

- [MBXRemote](https://halrad.com/MBXRemote/) - Windows desktop remote client for MusicBee
- [MusicBeeChromecast2026](https://halrad.com/MBChromecast-2026/) - Stream MusicBee to Chromecast devices

## Links

- [MusicBee TrueShuffle Website](https://halrad.com/MBTrueShuffle/)
- [MusicBee](https://getmusicbee.com/)
- [MusicBee Forum](https://getmusicbee.com/forum/)
